/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationCreatedEvent;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationDeletedEvent;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationUpdatedEvent;

@Named
@Singleton
public class BlobStoreConfigurationEntityAdapter
extends IterableEntityAdapter<BlobStoreConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("repository").type("blobstore").build();
    private static final String P_NAME = "name";
    private static final String P_TYPE = "type";
    private static final String P_ATTRIBUTES = "attributes";
    private final UpdateEntityByPropertyAction<BlobStoreConfiguration> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final ReadEntityByPropertyAction<BlobStoreConfiguration> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    @VisibleForTesting
    static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();

    public BlobStoreConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected BlobStoreConfiguration newEntity() {
        return new BlobStoreConfiguration();
    }

    protected void readFields(ODocument document, BlobStoreConfiguration entity) {
        String name = (String)document.field(P_NAME, OType.STRING);
        String type = (String)document.field(P_TYPE, OType.STRING);
        Map attributes = (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        entity.setName(name);
        entity.setType(type);
        entity.setAttributes(this.detachable(attributes));
    }

    protected void writeFields(ODocument document, BlobStoreConfiguration entity) {
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_ATTRIBUTES, (Object)entity.getAttributes());
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String name = (String)document.field(P_NAME);
        this.log.trace("newEvent: eventKind: {}, name: {}, metadata: {}", new Object[]{eventKind, name, metadata});
        switch (eventKind) {
            case CREATE: {
                return new BlobStoreConfigurationCreatedEvent((EntityMetadata)metadata, name);
            }
            case UPDATE: {
                return new BlobStoreConfigurationUpdatedEvent((EntityMetadata)metadata, name);
            }
            case DELETE: {
                return new BlobStoreConfigurationDeletedEvent((EntityMetadata)metadata, name);
            }
        }
        return null;
    }

    public boolean update(ODatabaseDocumentTx db, BlobStoreConfiguration entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getName()});
    }

    public BlobStoreConfiguration getByName(ODatabaseDocumentTx db, String name) {
        return (BlobStoreConfiguration)this.read.execute(db, new Object[]{name});
    }

    public Optional<BlobStoreConfiguration> getParent(ODatabaseDocumentTx db, String name) {
        String query = String.format("SELECT FROM %s WHERE ? in attributes.group.members", this.getTypeName());
        return ((List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[]{name})).stream().findFirst().map(arg_0 -> ((BlobStoreConfigurationEntityAdapter)this).readEntity(arg_0));
    }
}

