/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationEntityAdapter;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationStore;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class BlobStoreConfigurationStoreImpl
extends StateGuardLifecycleSupport
implements BlobStoreConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final BlobStoreConfigurationEntityAdapter entityAdapter;

    @Inject
    public BlobStoreConfigurationStoreImpl(@Named(value="config") Provider<DatabaseInstance> databaseInstance, BlobStoreConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<BlobStoreConfiguration> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(BlobStoreConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)configuration);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(BlobStoreConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.update(db, configuration);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(BlobStoreConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)configuration));
    }

    @Override
    @Guarded(by={"STARTED"})
    public BlobStoreConfiguration read(String name) {
        return (BlobStoreConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByName(db, name));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Optional<BlobStoreConfiguration> findParent(String name) {
        return (Optional)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getParent(db, name));
    }
}

