/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maintenance.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.maintenance.internal.DeleteFolderService;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.ComponentStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class DeleteFolderServiceImpl
extends ComponentSupport
implements DeleteFolderService {
    private final BrowseNodeStore browseNodeStore;
    private final BrowseNodeConfiguration configuration;
    private final AssetStore assetStore;
    private final ComponentStore componentStore;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;

    @Inject
    public DeleteFolderServiceImpl(BrowseNodeStore browseNodeStore, BrowseNodeConfiguration configuration, AssetStore assetStore, ComponentStore componentStore, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.browseNodeStore = (BrowseNodeStore)Preconditions.checkNotNull((Object)browseNodeStore);
        this.configuration = (BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.componentStore = (ComponentStore)Preconditions.checkNotNull((Object)componentStore);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
    }

    @Override
    public void deleteFolder(Repository repository, String treePath, DateTime timestamp, BooleanSupplier cancelledCheck) {
        ComponentMaintenance componentMaintenance = repository.facet(ComponentMaintenance.class);
        PriorityQueue<String> paths = new PriorityQueue<String>();
        paths.add(treePath);
        while (!cancelledCheck.getAsBoolean() && !paths.isEmpty()) {
            String basePath = (String)paths.poll();
            List<String> path = Arrays.asList(basePath.split("/"));
            Iterable<BrowseNode> nodes = this.browseNodeStore.getByPath(repository, path, this.configuration.getMaxNodes(), null);
            Iterator<BrowseNode> nodeIterator = nodes.iterator();
            HashSet<EntityId> components = new HashSet<EntityId>();
            while (!cancelledCheck.getAsBoolean() && nodeIterator.hasNext()) {
                BrowseNode node = nodeIterator.next();
                if (!node.isLeaf()) {
                    paths.offer(String.valueOf(basePath) + "/" + node.getName());
                }
                if (node.getAssetId() != null) {
                    this.deleteAsset(repository, node.getAssetId(), timestamp, componentMaintenance).ifPresent(components::add);
                }
                if (node.getComponentId() == null) continue;
                components.add(node.getComponentId());
            }
            Iterator componentIterator = components.iterator();
            while (!cancelledCheck.getAsBoolean() && componentIterator.hasNext()) {
                this.deleteComponent(repository, (EntityId)componentIterator.next(), componentMaintenance);
            }
        }
    }

    private void deleteComponent(Repository repository, EntityId componentId, ComponentMaintenance componentMaintenance) {
        if (this.canDeleteComponent(repository, this.componentStore.read(componentId))) {
            try {
                componentMaintenance.deleteComponent(componentId);
            }
            catch (Exception exception) {
                this.log.debug("Failed to delete a component '{}'", (Object)componentId);
            }
        }
    }

    private Optional<EntityId> deleteAsset(Repository repository, EntityId assetId, DateTime timestamp, ComponentMaintenance componentMaintenance) {
        EntityId componenetId = null;
        Asset asset = this.assetStore.getById(assetId);
        if (timestamp.isAfter((ReadableInstant)asset.blobCreated()) && this.canDeleteAsset(repository, asset)) {
            try {
                componentMaintenance.deleteAsset(assetId);
                componenetId = asset.componentId();
            }
            catch (Exception e) {
                this.log.error("Failed to delete an asset - skipping.", (Throwable)e);
            }
        }
        return Optional.ofNullable(componenetId);
    }

    private boolean canDeleteAsset(Repository repository, Asset asset) {
        return this.contentPermissionChecker.isPermitted(repository.getName(), repository.getFormat().getValue(), "delete", this.variableResolverAdapterManager.get(repository.getFormat().getValue()).fromAsset(asset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canDeleteComponent(Repository repository, Component component) {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            StorageTx storageTx;
            block8: {
                storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();
                storageTx.begin();
                Iterator<Asset> iterator = storageTx.browseAssets(component).iterator();
                finally {
                    if (!iterator.hasNext()) break block8;
                }
                Asset asset = iterator.next();
                if (!this.canDeleteAsset(repository, asset)) {
                    return false;
                }
            }
            if (storageTx == null) return true;
            storageTx.close();
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

