/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Facet;

public class FacetLookup
extends ComponentSupport
implements Iterable<Facet> {
    private final Set<Facet> facets = Sets.newLinkedHashSet();
    private final Map<Class<? extends Facet>, Facet> exposed = Maps.newHashMap();

    public void add(Facet facet) {
        Preconditions.checkNotNull((Object)facet);
        Class<?> root = facet.getClass();
        List<Class<? extends Facet>> types = this.exposedTypes(root);
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0, (String)"No exposed facets: %s", root);
        this.log.trace("Adding facet: {}, exposed as: {}", (Object)facet, types);
        for (Class<? extends Facet> type : types) {
            Preconditions.checkState((!this.exposed.containsKey(type) ? 1 : 0) != 0, (String)"Duplicate exposed facet type: %s, root type: %s", type, root);
        }
        this.facets.add(facet);
        for (Class<? extends Facet> type : types) {
            this.exposed.put(type, facet);
        }
    }

    private List<Class<? extends Facet>> exposedTypes(Class<? extends Facet> root) {
        ArrayList exposed = Lists.newArrayList();
        for (Class type : TypeToken.of(root).getTypes().rawTypes()) {
            if (!Facet.class.isAssignableFrom(type)) continue;
            Annotation[] annotationArray = type.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType() == Facet.Exposed.class) {
                    exposed.add(type);
                }
                ++n2;
            }
        }
        return exposed;
    }

    @Nullable
    public <T extends Facet> T get(Class<T> type) {
        Preconditions.checkNotNull(type);
        return (T)this.exposed.get(type);
    }

    public void clear() {
        this.facets.clear();
        this.exposed.clear();
    }

    @Override
    public Iterator<Facet> iterator() {
        return Iterators.unmodifiableIterator(this.facets.iterator());
    }

    public Iterable<Facet> reverse() {
        return ImmutableList.copyOf(this.facets).reverse();
    }
}

