/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.RepositoryAdminPrivilegeDescriptor;
import org.sonatype.nexus.security.config.MutableSecurityContributor;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfigurationManager;

@Named
@Singleton
public class RepositoryAdminSecurityContributor
extends MutableSecurityContributor {
    protected void initial(SecurityConfiguration model) {
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "*"));
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "browse"));
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "read"));
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "edit"));
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "add"));
        model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege("*", "*", "delete"));
    }

    public void add(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        String name = repository.getName();
        this.apply((model, configurationManager) -> {
            model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege(format, name, "*"));
            model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege(format, name, "browse"));
            model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege(format, name, "read"));
            model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege(format, name, "edit"));
            model.addPrivilege(RepositoryAdminPrivilegeDescriptor.privilege(format, name, "delete"));
        });
    }

    public void remove(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        String name = repository.getName();
        List<String> privilegeIds = Arrays.asList(RepositoryAdminPrivilegeDescriptor.id(format, name, "*"), RepositoryAdminPrivilegeDescriptor.id(format, name, "browse"), RepositoryAdminPrivilegeDescriptor.id(format, name, "read"), RepositoryAdminPrivilegeDescriptor.id(format, name, "edit"), RepositoryAdminPrivilegeDescriptor.id(format, name, "delete"));
        this.apply((model, configurationManager) -> {
            privilegeIds.forEach(arg_0 -> ((SecurityConfiguration)model).removePrivilege(arg_0));
            privilegeIds.forEach(arg_0 -> ((SecurityConfigurationManager)configurationManager).cleanRemovedPrivilege(arg_0));
        });
    }
}

