/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryDestroyedEvent;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.RepositoryStartedEvent;
import org.sonatype.nexus.repository.RepositoryStoppedEvent;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryRestoredEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;

@Named
@Singleton
public class RepositoryAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository";

    public RepositoryAuditor() {
        this.registerType(RepositoryCreatedEvent.class, "created");
        this.registerType(RepositoryRestoredEvent.class, "restored");
        this.registerType(RepositoryUpdatedEvent.class, "updated");
        this.registerType(RepositoryDestroyedEvent.class, "destroyed");
        this.registerType(RepositoryDeletedEvent.class, "deleted");
        this.registerType(RepositoryLoadedEvent.class, "loaded");
        this.registerType(RepositoryStartedEvent.class, "started");
        this.registerType(RepositoryStoppedEvent.class, "stopped");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        if (this.isRecording()) {
            Repository repository = event.getRepository();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(repository.getName());
            Map attributes = data.getAttributes();
            attributes.put("name", repository.getName());
            attributes.put("type", repository.getType().getValue());
            attributes.put("format", repository.getFormat().getValue());
            this.record(data);
        }
    }
}

