/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.manager.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventConsumer;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseFacet;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.config.internal.ConfigurationCreatedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationEvent;
import org.sonatype.nexus.repository.config.internal.ConfigurationStore;
import org.sonatype.nexus.repository.config.internal.ConfigurationUpdatedEvent;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.DefaultRepositoriesContributor;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryLoadedEvent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryMetadataUpdatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryRestoredEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.manager.internal.RepositoryAdminSecurityContributor;
import org.sonatype.nexus.repository.manager.internal.RepositoryFactory;
import org.sonatype.nexus.repository.storage.internal.BucketUpdatedEvent;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@ManagedObject(domain="org.sonatype.nexus.repository.manager", typeClass=RepositoryManager.class, description="Repository manager")
public class RepositoryManagerImpl
extends StateGuardLifecycleSupport
implements RepositoryManager,
EventAware {
    public static final String CLEANUP_ATTRIBUTES_KEY = "cleanup";
    public static final String CLEANUP_NAME_KEY = "policyName";
    private final DatabaseFreezeService databaseFreezeService;
    private final EventManager eventManager;
    private final ConfigurationStore store;
    private final Map<String, Recipe> recipes;
    private final RepositoryFactory factory;
    private final Provider<ConfigurationFacet> configFacet;
    private final Provider<BrowseFacet> browseFacet;
    private final RepositoryAdminSecurityContributor securityContributor;
    private final List<DefaultRepositoriesContributor> defaultRepositoriesContributors;
    private final Map<String, Repository> repositories = Maps.newConcurrentMap();
    private final boolean skipDefaultRepositories;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public RepositoryManagerImpl(EventManager eventManager, ConfigurationStore store, RepositoryFactory factory, Provider<ConfigurationFacet> configFacet, Provider<BrowseFacet> browseFacet, Map<String, Recipe> recipes, RepositoryAdminSecurityContributor securityContributor, List<DefaultRepositoriesContributor> defaultRepositoriesContributors, DatabaseFreezeService databaseFreezeService, @Named(value="${nexus.skipDefaultRepositories:-false}") boolean skipDefaultRepositories, BlobStoreManager blobStoreManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.store = (ConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.factory = (RepositoryFactory)Preconditions.checkNotNull((Object)factory);
        this.configFacet = (Provider)Preconditions.checkNotNull(configFacet);
        this.browseFacet = (Provider)Preconditions.checkNotNull(browseFacet);
        this.recipes = (Map)Preconditions.checkNotNull(recipes);
        this.securityContributor = (RepositoryAdminSecurityContributor)((Object)Preconditions.checkNotNull((Object)((Object)securityContributor)));
        this.defaultRepositoriesContributors = (List)Preconditions.checkNotNull(defaultRepositoriesContributors);
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
        this.skipDefaultRepositories = skipDefaultRepositories;
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    private Recipe recipe(String name) {
        Recipe recipe = this.recipes.get(name);
        Preconditions.checkState((recipe != null ? 1 : 0) != 0, (String)"Missing recipe: %s", (Object)name);
        return recipe;
    }

    private Repository repository(String name) {
        Repository repository = this.repositories.get(name);
        Preconditions.checkState((repository != null ? 1 : 0) != 0, (String)"Missing repository: %s", (Object)name);
        return repository;
    }

    private Repository newRepository(Configuration configuration) throws Exception {
        String recipeName = configuration.getRecipeName();
        Recipe recipe = this.recipe(recipeName);
        this.log.debug("Using recipe: [{}] {}", (Object)recipeName, (Object)recipe);
        Repository repository = this.factory.create(recipe.getType(), recipe.getFormat());
        repository.attach((Facet)this.configFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        recipe.apply(repository);
        repository.facet(ViewFacet.class);
        repository.validate(configuration);
        repository.init(configuration);
        return repository;
    }

    private void track(Repository repository) {
        this.securityContributor.add(repository);
        this.log.debug("Tracking: {}", (Object)repository);
        this.repositories.put(repository.getName(), repository);
    }

    private void untrack(Repository repository) {
        this.log.debug("Untracking: {}", (Object)repository);
        this.repositories.remove(repository.getName());
        this.securityContributor.remove(repository);
    }

    protected void doStart() throws Exception {
        this.blobStoreManager.start();
        List<Configuration> configurations = this.store.list();
        if (configurations.isEmpty()) {
            if (this.skipDefaultRepositories || !this.blobStoreManager.exists("default")) {
                this.log.debug("Skipping provisioning of default repositories");
                return;
            }
            this.log.debug("No repositories configured; provisioning default repositories");
            this.provisionDefaultRepositories();
            configurations = this.store.list();
            if (configurations.isEmpty()) {
                this.log.debug("No default repositories to provision");
                return;
            }
        }
        this.restoreRepositories(configurations);
        this.startRepositories();
    }

    private void provisionDefaultRepositories() {
        for (DefaultRepositoriesContributor contributor : this.defaultRepositoriesContributors) {
            for (Configuration configuration : contributor.getRepositoryConfigurations()) {
                this.log.debug("Provisioning default repository: {}", (Object)configuration);
                this.store.create(configuration);
            }
        }
    }

    private void restoreRepositories(List<Configuration> configurations) throws Exception {
        this.log.debug("Restoring {} repositories", (Object)configurations.size());
        for (Configuration configuration : configurations) {
            this.log.debug("Restoring repository: {}", (Object)configuration);
            Repository repository = this.newRepository(configuration);
            this.track(repository);
            this.eventManager.post((Object)new RepositoryLoadedEvent(repository));
        }
    }

    private void startRepositories() throws Exception {
        this.log.debug("Starting {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Starting repository: {}", (Object)repository);
            repository.start();
            this.eventManager.post((Object)new RepositoryRestoredEvent(repository));
        }
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Stopping repository: {}", (Object)repository);
            repository.stop();
        }
        this.log.debug("Destroying {} repositories", (Object)this.repositories.size());
        for (Repository repository : this.repositories.values()) {
            this.log.debug("Destroying repository: {}", (Object)repository);
            repository.destroy();
        }
        this.repositories.clear();
        this.blobStoreManager.stop();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Iterable<Repository> browse() {
        return ImmutableList.copyOf(this.repositories.values());
    }

    @Override
    @Guarded(by={"STARTED"})
    public Iterable<Repository> browseForBlobStore(String blobStoreId) {
        return StreamSupport.stream(this.browse().spliterator(), true).filter(r -> blobStoreId.equals(r.getConfiguration().attributes("storage").get("blobStoreName")))::iterator;
    }

    @Override
    public boolean exists(String name) {
        return StreamSupport.stream(this.browse().spliterator(), false).anyMatch(repository -> repository.getName().equalsIgnoreCase(name));
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Repository get(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.repositories.get(name);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Repository create(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        String repositoryName = (String)Preconditions.checkNotNull((Object)configuration.getRepositoryName());
        this.log.info("Creating repository: {} -> {}", (Object)repositoryName, (Object)configuration);
        Repository repository = this.newRepository(configuration);
        if (!EventHelper.isReplicating()) {
            this.store.create(configuration);
        }
        this.track(repository);
        repository.start();
        this.eventManager.post((Object)new RepositoryCreatedEvent(repository));
        return repository;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Repository update(Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        String repositoryName = (String)Preconditions.checkNotNull((Object)configuration.getRepositoryName());
        this.log.info("Updating repository: {} -> {}", (Object)repositoryName, (Object)configuration);
        Repository repository = this.repository(repositoryName);
        repository.validate(configuration);
        if (!EventHelper.isReplicating()) {
            this.store.update(configuration);
        }
        repository.stop();
        repository.update(configuration);
        repository.start();
        this.eventManager.post((Object)new RepositoryUpdatedEvent(repository));
        return repository;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(String name) throws Exception {
        Preconditions.checkNotNull((Object)name);
        this.databaseFreezeService.checkUnfrozen("Unable to delete repository when database is frozen.");
        this.log.info("Deleting repository: {}", (Object)name);
        Repository repository = this.repository(name);
        Configuration configuration = repository.getConfiguration();
        this.removeRepositoryFromAllGroups(repository);
        repository.stop();
        repository.delete();
        repository.destroy();
        if (!EventHelper.isReplicating()) {
            this.store.delete(configuration);
        }
        this.untrack(repository);
        this.eventManager.post((Object)new RepositoryDeletedEvent(repository));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<String> findContainingGroups(String repositoryName) {
        TreeMap<Integer, List<String>> groupNamesByLevel = new TreeMap<Integer, List<String>>();
        this.findContainingGroups(repositoryName, groupNamesByLevel, 0);
        return groupNamesByLevel.values().stream().map(repoNames -> {
            repoNames.sort(null);
            return repoNames;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void findContainingGroups(String name, SortedMap<Integer, List<String>> groupNamesByLevel, int level) {
        ArrayList newContainingGroups = new ArrayList();
        this.repositories.values().stream().filter(repository -> repository.optionalFacet(GroupFacet.class).filter(groupFacet -> groupFacet.member(name)).isPresent() && groupNamesByLevel.values().stream().noneMatch(repoNames -> repoNames.contains(repository.getName()))).forEach(repository -> {
            boolean bl = newContainingGroups.add(repository.getName());
        });
        List groupNames = groupNamesByLevel.computeIfAbsent(level, newLevel -> new ArrayList());
        groupNames.addAll(newContainingGroups);
        newContainingGroups.forEach(newName -> this.findContainingGroups((String)newName, groupNamesByLevel, level + 1));
    }

    private void removeRepositoryFromAllGroups(Repository repositoryToRemove) throws Exception {
        for (Repository group : this.repositories.values()) {
            Optional<GroupFacet> groupFacet = group.optionalFacet(GroupFacet.class);
            if (!groupFacet.isPresent() || !groupFacet.get().member(repositoryToRemove)) continue;
            this.removeRepositoryFromGroup(repositoryToRemove, group);
        }
    }

    private void removeRepositoryFromGroup(Repository repositoryToRemove, Repository group) throws Exception {
        NestedAttributesMap groupAttributes = group.getConfiguration().attributes("group");
        ((Collection)groupAttributes.get("memberNames", Collection.class)).remove(repositoryToRemove.getName());
        this.update(group.getConfiguration());
    }

    private Stream<Object> blobstoreUsageStream(String blobStoreName) {
        return StreamSupport.stream(this.browse().spliterator(), false).map(Repository::getConfiguration).map(Configuration::getAttributes).map(a -> (Map)a.get("storage")).map(s -> s.get("blobStoreName")).filter(blobStoreName::equals);
    }

    @Override
    public boolean isBlobstoreUsed(String blobStoreName) {
        return this.blobstoreUsageStream(blobStoreName).findAny().isPresent() || this.blobStoreManager.blobStoreUsageCount(blobStoreName) > 0L;
    }

    @Override
    public long blobstoreUsageCount(String blobStoreName) {
        return this.blobstoreUsageStream(blobStoreName).count();
    }

    @Override
    public Stream<Repository> browseForCleanupPolicy(String cleanupPolicyName) {
        return StreamSupport.stream(this.browse().spliterator(), false).filter(repository -> this.repositoryHasCleanupPolicy((Repository)repository, cleanupPolicyName));
    }

    @Subscribe
    public void on(ConfigurationCreatedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.create(e.getConfiguration());
        }));
    }

    @Subscribe
    public void on(ConfigurationUpdatedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> {
            Repository repository = this.update(e.getConfiguration());
        }));
    }

    @Subscribe
    public void on(ConfigurationDeletedEvent event) {
        this.handleReplication(event, (EventConsumer<ConfigurationEvent>)((EventConsumer)e -> this.delete(e.getRepositoryName())));
    }

    private void handleReplication(ConfigurationEvent event, EventConsumer<ConfigurationEvent> consumer) {
        if (!event.isLocal()) {
            try {
                consumer.accept((Object)event);
            }
            catch (Exception e) {
                this.log.error("Failed to replicate: {}", (Object)event, (Object)e);
            }
        }
    }

    @Subscribe
    public void onBucketUpdated(BucketUpdatedEvent event) {
        Repository repository = this.repositories.get(event.getRepositoryName());
        if (repository != null) {
            this.eventManager.post((Object)new RepositoryMetadataUpdatedEvent(repository));
        } else {
            this.log.debug("Not posting metadata update event for deleted repository {}", (Object)event.getRepositoryName());
        }
    }

    private boolean repositoryHasCleanupPolicy(Repository repository, String cleanupPolicyName) {
        return Optional.ofNullable(repository.getConfiguration()).map(Configuration::getAttributes).map(attributes -> (Map)attributes.get(CLEANUP_ATTRIBUTES_KEY)).filter(Objects::nonNull).map(cleanupPolicyMap -> cleanupPolicyMap.get(CLEANUP_NAME_KEY)).filter(cleanupPolicyName::equals).isPresent();
    }
}

