/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.HttpClientUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.repository.BadRequestException;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.httpclient.RemoteBlockedIOException;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyServiceException;
import org.sonatype.nexus.repository.proxy.TempContent;
import org.sonatype.nexus.repository.storage.MissingBlobException;
import org.sonatype.nexus.repository.storage.RetryDeniedException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.payloads.HttpEntityPayload;
import org.sonatype.nexus.validation.constraint.Url;

public abstract class ProxyFacetSupport
extends FacetSupport
implements ProxyFacet {
    @VisibleForTesting
    static final String CONFIG_KEY = "proxy";
    private Config config;
    private HttpClientFacet httpClient;
    private boolean remoteUrlChanged;
    protected CacheControllerHolder cacheControllerHolder;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation proxyCooperation;

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.proxy.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.proxy.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.proxy.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.proxy.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            this.proxyCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":proxy");
        }
    }

    @Override
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    @Override
    protected void doValidate(Configuration configuration) throws Exception {
        this.facet(ConfigurationFacet.class).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    @Override
    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = this.facet(ConfigurationFacet.class).readSection(configuration, CONFIG_KEY, Config.class);
        this.cacheControllerHolder = new CacheControllerHolder(new CacheController(Time.minutes((long)this.config.contentMaxAge.intValue()).toSecondsI(), null), new CacheController(Time.minutes((long)this.config.metadataMaxAge.intValue()).toSecondsI(), null));
        if (!this.config.remoteUrl.getPath().endsWith("/")) {
            this.config.remoteUrl = this.config.remoteUrl.resolve(String.valueOf(this.config.remoteUrl.getPath()) + "/");
        }
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    protected void doUpdate(Configuration configuration) throws Exception {
        URI previousUrl = this.config.remoteUrl;
        super.doUpdate(configuration);
        this.remoteUrlChanged = !this.config.remoteUrl.equals(previousUrl);
    }

    @Override
    protected void doDestroy() throws Exception {
        this.config = null;
    }

    @Override
    protected void doStart() throws Exception {
        this.httpClient = this.facet(HttpClientFacet.class);
        if (this.remoteUrlChanged) {
            this.remoteUrlChanged = false;
            this.optionalFacet(NegativeCacheFacet.class).ifPresent(nfc -> nfc.invalidate());
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.httpClient = null;
    }

    @Override
    public URI getRemoteUrl() {
        return this.config.remoteUrl;
    }

    @Override
    public Content get(Context context) throws IOException {
        Preconditions.checkNotNull((Object)context);
        Content content = this.maybeGetCachedContent(context);
        if (!this.isStale(context, content)) {
            return content;
        }
        if (this.proxyCooperation == null) {
            return this.doGet(context, content);
        }
        return (Content)this.proxyCooperation.cooperate(this.getRequestKey(context), failover -> {
            Content latestContent = content;
            if (failover && !this.isStale(context, latestContent = (Content)this.proxyCooperation.join(() -> this.maybeGetCachedContent(context)))) {
                return latestContent;
            }
            return this.doGet(context, latestContent);
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Content doGet(Context context, @Nullable Content staleContent) throws IOException {
        Content remote = null;
        Content content = staleContent;
        try {
            try {
                remote = this.fetch(context, content);
                if (remote == null) return content;
                content = this.store(context, remote);
                if (this.proxyCooperation == null || !remote.equals(content)) return content;
                content = new TempContent(remote);
                return content;
            }
            catch (ProxyServiceException e) {
                this.logContentOrThrow(content, context, e.getHttpResponse().getStatusLine(), e);
                if (remote == null || remote.equals(content)) return content;
                Closeables.close((Closeable)remote, (boolean)true);
                return content;
            }
            catch (IOException e) {
                this.logContentOrThrow(content, context, null, e);
                if (remote == null || remote.equals(content)) return content;
                Closeables.close((Closeable)remote, (boolean)true);
                return content;
            }
            catch (UncheckedIOException e) {
                this.logContentOrThrow(content, context, null, e.getCause());
                if (remote == null || remote.equals(content)) return content;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Closeables.close((Closeable)remote, (boolean)true);
                return content;
            }
        }
        finally {
            if (remote != null && !remote.equals(content)) {
                Closeables.close((Closeable)remote, (boolean)true);
            }
        }
    }

    protected String getRequestKey(Context context) {
        return String.valueOf(context.getRequest().getPath()) + '?' + (Object)((Object)context.getRequest().getParameters());
    }

    private <X extends Throwable> void logContentOrThrow(@Nullable Content content, Context context, @Nullable StatusLine statusLine, X exception) throws X {
        String logMessage = this.buildLogContentMessage(content, statusLine);
        String repositoryName = context.getRepository().getName();
        String contextUrl = this.getUrl(context);
        if (content == null) {
            if (exception instanceof RemoteBlockedIOException) {
                this.log.trace(logMessage, new Object[]{exception, repositoryName, contextUrl, statusLine, exception});
            } else if (this.log.isDebugEnabled()) {
                this.log.warn(logMessage, new Object[]{exception, repositoryName, contextUrl, statusLine, exception});
            } else {
                this.log.warn(logMessage, new Object[]{exception, repositoryName, contextUrl, statusLine});
            }
            throw exception;
        }
        this.log.debug(logMessage, new Object[]{exception, repositoryName, contextUrl, statusLine});
    }

    @VisibleForTesting
    <X extends Throwable> String buildLogContentMessage(@Nullable Content content, @Nullable StatusLine statusLine) {
        StringBuilder message = new StringBuilder("Exception {} checking remote for update");
        if (statusLine == null) {
            message.append(", proxy repo {} failed to fetch {}");
        } else {
            message.append(", proxy repo {} failed to fetch {} with status line {}");
        }
        if (content == null) {
            message.append(", content not in cache.");
        } else {
            message.append(", returning content from cache.");
        }
        return message.toString();
    }

    @Override
    public void invalidateProxyCaches() {
        this.log.info("Invalidating proxy caches of {}", (Object)this.getRepository().getName());
        this.cacheControllerHolder.invalidateCaches();
    }

    private Content maybeGetCachedContent(Context context) throws IOException {
        try {
            return this.getCachedContent(context);
        }
        catch (RetryDeniedException e) {
            if (e.getCause() instanceof MissingBlobException) {
                this.log.warn("Unable to find blob {} for {}, will check remote", (Object)((MissingBlobException)e.getCause()).getBlobRef(), (Object)this.getUrl(context));
                return null;
            }
            throw e;
        }
    }

    @Nullable
    protected abstract Content getCachedContent(Context var1) throws IOException;

    protected abstract Content store(Context var1, Content var2) throws IOException;

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        return this.fetch(this.getUrl(context), context, stale);
    }

    protected Content fetch(String url, Context context, @Nullable Content stale) throws IOException {
        URI uri;
        HttpClient client = this.httpClient.getHttpClient();
        Preconditions.checkState((boolean)this.config.remoteUrl.isAbsolute(), (String)"Invalid remote URL '%s' for proxy repository %s, please fix your configuration", (Object)this.config.remoteUrl, (Object)this.getRepository().getName());
        try {
            uri = this.config.remoteUrl.resolve(url);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Unable to resolve url. Reason: {}", (Object)e.getMessage());
            throw new BadRequestException("Invalid repository path");
        }
        HttpRequestBase request = this.buildFetchHttpRequest(uri, context);
        if (stale != null) {
            String etag;
            DateTime lastModified = (DateTime)stale.getAttributes().get("lastModified", DateTime.class);
            if (lastModified != null) {
                request.addHeader("If-Modified-Since", DateUtils.formatDate((Date)lastModified.toDate()));
            }
            if ((etag = (String)stale.getAttributes().get("etag", String.class)) != null) {
                request.addHeader("If-None-Match", "\"" + etag + "\"");
            }
        }
        this.log.debug("Fetching: {}", (Object)request);
        HttpResponse response = this.execute(context, client, request);
        this.log.debug("Response: {}", (Object)response);
        StatusLine status = response.getStatusLine();
        this.log.debug("Status: {}", (Object)status);
        CacheInfo cacheInfo = this.getCacheController(context).current();
        if (status.getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            this.log.debug("Entity: {}", (Object)entity);
            Content result = this.createContent(context, response);
            result.getAttributes().set("lastModified", (Object)this.extractLastModified(request, response));
            result.getAttributes().set("etag", (Object)this.extractETag(response));
            result.getAttributes().set(CacheInfo.class, (Object)cacheInfo);
            return result;
        }
        try {
            if (status.getStatusCode() == 304) {
                Preconditions.checkState((stale != null ? 1 : 0) != 0, (String)"Received 304 without conditional GET (bad server?) from %s", (Object)uri);
                this.indicateVerified(context, stale, cacheInfo);
            }
            this.mayThrowProxyServiceException(response);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        return null;
    }

    protected Content createContent(Context context, HttpResponse response) {
        return new Content(new HttpEntityPayload(response, response.getEntity()));
    }

    private void mayThrowProxyServiceException(HttpResponse httpResponse) {
        StatusLine status = httpResponse.getStatusLine();
        if (401 == status.getStatusCode() || 402 == status.getStatusCode() || 407 == status.getStatusCode() || 500 <= status.getStatusCode()) {
            throw new ProxyServiceException(httpResponse);
        }
    }

    protected HttpResponse execute(Context context, HttpClient client, HttpRequestBase request) throws IOException {
        return client.execute((HttpUriRequest)request);
    }

    protected HttpRequestBase buildFetchHttpRequest(URI uri, Context context) {
        return new HttpGet(uri);
    }

    @Nullable
    private DateTime extractLastModified(HttpRequestBase request, HttpResponse response) {
        Header lastModifiedHeader = response.getLastHeader("Last-Modified");
        if (lastModifiedHeader != null) {
            try {
                return new DateTime(DateUtils.parseDate((String)lastModifiedHeader.getValue()).getTime());
            }
            catch (Exception exception) {
                this.log.warn("Could not parse date '{}' received from {}; using system current time as item creation time", (Object)lastModifiedHeader, (Object)request.getURI());
            }
        }
        return null;
    }

    @Nullable
    private String extractETag(HttpResponse response) {
        String etag;
        Header etagHeader = response.getLastHeader("ETag");
        if (etagHeader != null && !Strings.isNullOrEmpty((String)(etag = etagHeader.getValue()))) {
            if (etag.startsWith("\"") && etag.endsWith("\"")) {
                return etag.substring(1, etag.length() - 1);
            }
            return etag;
        }
        return null;
    }

    protected abstract void indicateVerified(Context var1, Content var2, CacheInfo var3) throws IOException;

    protected abstract String getUrl(@Nonnull Context var1);

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        return this.cacheControllerHolder.getContentCacheController();
    }

    private boolean isStale(Context context, Content content) {
        if (content == null) {
            return true;
        }
        CacheInfo cacheInfo = (CacheInfo)content.getAttributes().get(CacheInfo.class);
        return cacheInfo == null || this.getCacheController(context).isStale(cacheInfo);
    }

    @VisibleForTesting
    Map<String, Integer> getThreadCooperationPerRequest() {
        return this.proxyCooperation.getThreadCountPerKey();
    }

    @VisibleForTesting
    public static class Config {
        @Url
        @NotNull
        public URI remoteUrl;
        @NotNull
        public Integer contentMaxAge = Time.hours((long)24L).toMinutesI();
        @NotNull
        public Integer metadataMaxAge = Time.hours((long)24L).toMinutesI();

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "remoteUrl=" + this.remoteUrl + ", contentMaxAge=" + this.contentMaxAge + '}';
        }
    }
}

