/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.purge;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PurgeUnusedFacetImpl
extends FacetSupport
implements PurgeUnusedFacet {
    private final ComponentEntityAdapter componentEntityAdapter;

    @Inject
    public PurgeUnusedFacetImpl(ComponentEntityAdapter componentEntityAdapter) {
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void purgeUnused(int numberOfDays) {
        Preconditions.checkArgument((numberOfDays > 0 ? 1 : 0) != 0, (Object)"Number of days must be greater then zero");
        this.log.info("Purging unused components from repository {}", (Object)this.getRepository().getName());
        Date olderThan = DateTime.now().minusDays(numberOfDays).withTimeAtStartOfDay().toDate();
        UnitOfWork.beginBatch(this.facet(StorageFacet.class).txSupplier());
        try {
            this.deleteUnusedComponents(olderThan);
            this.deleteUnusedAssets(olderThan);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void deleteUnusedComponents(Date olderThan) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        for (Component component : this.findUnusedComponents(tx, olderThan)) {
            CancelableHelper.checkCancellation();
            this.log.debug("Deleting unused component {}", (Object)component);
            tx.deleteComponent(component);
        }
    }

    @TransactionalDeleteBlob
    protected void deleteUnusedAssets(Date olderThan) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        for (Asset asset : this.findUnusedAssets(tx, olderThan)) {
            CancelableHelper.checkCancellation();
            this.log.debug("Deleting unused asset {}", (Object)asset);
            tx.deleteAsset(asset);
        }
    }

    private Iterable<Component> findUnusedComponents(StorageTx tx, Date olderThan) {
        Bucket bucket = tx.findBucket(this.getRepository());
        String sql = String.format("SELECT FROM (SELECT %s, MAX(%s) AS lastDownloaded FROM asset WHERE %s=:bucket AND %s IS NOT NULL GROUP BY %s) WHERE lastDownloaded < :olderThan", "component", "last_downloaded", "bucket", "component", "component");
        ImmutableMap sqlParams = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket), (Object)"olderThan", (Object)olderThan);
        CancelableHelper.checkCancellation();
        return Iterables.transform(tx.browse(sql, (Map<String, Object>)sqlParams), doc -> (Component)this.componentEntityAdapter.readEntity((ODocument)doc.field("component")));
    }

    private Iterable<Asset> findUnusedAssets(StorageTx tx, Date olderThan) {
        String whereClause = String.format("%s IS NULL AND %s < :olderThan", "component", "last_downloaded");
        ImmutableMap sqlParams = ImmutableMap.of((Object)"olderThan", (Object)olderThan);
        CancelableHelper.checkCancellation();
        return tx.findAssets(whereClause, (Map<String, Object>)sqlParams, (Iterable<Repository>)ImmutableList.of((Object)this.getRepository()), null);
    }
}

