/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.internal.resources.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.search.SearchContribution;
import org.sonatype.nexus.repository.search.SearchFilter;

@Named
@Singleton
public class SearchUtils
extends ComponentSupport {
    private static final String CONTINUATION_TOKEN = "continuationToken";
    private static final String ASSET_PREFIX = "assets.";
    private final RepositoryManagerRESTAdapter repoAdapter;
    private final Map<String, String> searchParams;
    private final Map<String, String> assetSearchParams;
    private final Map<String, SearchContribution> searchContributions;
    private final SearchContribution defaultSearchContribution;

    @Inject
    public SearchUtils(RepositoryManagerRESTAdapter repoAdapter, Map<String, SearchMappings> searchMappings, Map<String, SearchContribution> searchContributions) {
        this.repoAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repoAdapter);
        this.searchParams = ((Map)Preconditions.checkNotNull(searchMappings)).entrySet().stream().flatMap(e -> StreamSupport.stream(((SearchMappings)e.getValue()).get().spliterator(), true)).collect(Collectors.toMap(SearchMapping::getAlias, SearchMapping::getAttribute));
        this.assetSearchParams = this.searchParams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith(ASSET_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.searchContributions = (Map)Preconditions.checkNotNull(searchContributions);
        this.defaultSearchContribution = (SearchContribution)Preconditions.checkNotNull((Object)searchContributions.get("default"));
    }

    public Map<String, String> getSearchParameters() {
        return this.searchParams;
    }

    public Map<String, String> getAssetSearchParameters() {
        return this.assetSearchParams;
    }

    public Repository getRepository(String repository) {
        return this.repoAdapter.getRepository(repository);
    }

    public QueryBuilder buildQuery(Collection<SearchFilter> searchFilters) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        searchFilters.stream().filter(searchFilter -> !Strings2.isBlank((String)searchFilter.getValue())).forEach(searchFilter -> {
            SearchContribution searchContribution = this.searchContributions.getOrDefault(searchFilter.getProperty(), this.defaultSearchContribution);
            searchContribution.contribute(query, searchFilter.getProperty(), searchFilter.getValue());
        });
        this.log.debug("Query: {}", (Object)query);
        return query;
    }

    public QueryBuilder buildQuery(UriInfo uriInfo) {
        Collection<SearchFilter> searchFilters = this.convertParameters(uriInfo);
        return this.buildQuery(searchFilters);
    }

    private Collection<SearchFilter> convertParameters(UriInfo uriInfo) {
        return uriInfo.getQueryParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(CONTINUATION_TOKEN)).map(entry -> ((List)entry.getValue()).stream().map(value -> {
            String key = this.searchParams.getOrDefault(entry.getKey(), (String)entry.getKey());
            return new SearchFilter(key, (String)value);
        }).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean isAssetSearchParam(String assetSearchParam) {
        return this.assetSearchParams.containsKey(assetSearchParam) || this.isFullAssetAttributeName(assetSearchParam);
    }

    public boolean isFullAssetAttributeName(String assetSearchParam) {
        return assetSearchParam.startsWith(ASSET_PREFIX);
    }

    public String getFullAssetAttributeName(String key) {
        return this.isFullAssetAttributeName(key) ? key : this.getAssetSearchParameters().get(key);
    }
}

