/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.SearchMappingsService;

@Named
@Singleton
public class SearchMappingsServiceImpl
extends ComponentSupport
implements SearchMappingsService {
    private static final String DEFAULT = "default";
    private final Collection<SearchMapping> searchMappings;

    @Inject
    public SearchMappingsServiceImpl(Map<String, SearchMappings> searchMappings) {
        this.searchMappings = SearchMappingsServiceImpl.collectMappings((Map)Preconditions.checkNotNull(searchMappings));
    }

    private static Collection<SearchMapping> collectMappings(Map<String, SearchMappings> searchMappings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        SearchMappings defaultMappings = searchMappings.get(DEFAULT);
        if (defaultMappings != null) {
            builder.addAll(defaultMappings.get());
        }
        searchMappings.keySet().stream().filter(key -> !DEFAULT.equals(key)).sorted().forEach(key -> {
            ImmutableList.Builder builder2 = builder.addAll(((SearchMappings)searchMappings.get(key)).get());
        });
        return builder.build();
    }

    @Override
    public Iterable<SearchMapping> getAllMappings() {
        return this.searchMappings;
    }
}

