/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.rest.WebApplicationMessageException;

public class AssetDownloadResponseProcessor {
    public static final String NO_SEARCH_RESULTS_FOUND = "Asset search returned no results";
    public static final String SEARCH_RETURNED_MULTIPLE_ASSETS = "Search returned multiple assets, please refine search criteria to find a single asset";
    private final List<AssetXO> assetXOs;

    AssetDownloadResponseProcessor(List<AssetXO> assetXOs) {
        this.assetXOs = assetXOs;
    }

    Response process() {
        if (this.assetXOs.isEmpty()) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, NO_SEARCH_RESULTS_FOUND);
        }
        if (this.assetXOs.size() > 1) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, SEARCH_RETURNED_MULTIPLE_ASSETS);
        }
        return this.getResponse(this.assetXOs.get(0));
    }

    private Response getResponse(AssetXO assetXO) {
        String redirectUrl = assetXO.getDownloadUrl();
        URI uri = UriBuilder.fromPath((String)redirectUrl).build(new Object[0]);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.FOUND).location(uri);
        return builder.build();
    }
}

