/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.sonatype.nexus.repository.rest.SearchUtils;

@Named
@Singleton
class AssetMapUtils {
    private static final String EMPTY_PARAM = "";
    private final SearchUtils searchUtils;

    @Inject
    public AssetMapUtils(SearchUtils searchUtils) {
        this.searchUtils = (SearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)searchUtils)));
    }

    static Optional<Object> getValueFromAssetMap(Map<String, Object> assetMap, String identifier) {
        if (Strings.isNullOrEmpty((String)identifier) || assetMap.isEmpty()) {
            return Optional.empty();
        }
        ArrayList keys = Lists.newArrayList((Object[])identifier.split("\\."));
        if ("assets".equals(keys.get(0))) {
            keys.remove(0);
        }
        Object value = assetMap;
        for (String key : keys) {
            if (value == null) {
                return Optional.empty();
            }
            value = value.get(key);
        }
        return Optional.ofNullable(value);
    }

    @VisibleForTesting
    boolean filterAsset(Map<String, Object> assetMap, MultivaluedMap<String, String> assetParams) {
        if (AssetMapUtils.excludeAsset(assetMap, this.getEmptyAssetParams(assetParams))) {
            return false;
        }
        Map<String, String> assetParamsWithValues = this.getNonEmptyAssetParams(assetParams);
        if (assetParamsWithValues.isEmpty()) {
            return true;
        }
        return assetParamsWithValues.entrySet().stream().allMatch(entry -> AssetMapUtils.keepAsset(assetMap, (String)entry.getKey(), (String)entry.getValue()));
    }

    static boolean excludeAsset(Map<String, Object> assetMap, List<String> paramFilters) {
        return paramFilters.stream().anyMatch(filter -> AssetMapUtils.getValueFromAssetMap(assetMap, filter).isPresent());
    }

    static boolean keepAsset(Map<String, Object> assetMap, String paramKey, String paramValue) {
        return AssetMapUtils.getValueFromAssetMap(assetMap, paramKey).map(result -> result.equals(paramValue)).orElse(false);
    }

    @VisibleForTesting
    List<String> getEmptyAssetParams(MultivaluedMap<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> EMPTY_PARAM.equals(((List)entry.getValue()).get(0))).map(e -> this.searchUtils.getFullAssetAttributeName((String)e.getKey())).collect(Collectors.toList());
    }

    @VisibleForTesting
    Map<String, String> getNonEmptyAssetParams(MultivaluedMap<String, String> assetParams) {
        return assetParams.entrySet().stream().filter(entry -> !EMPTY_PARAM.equals(((List)entry.getValue()).get(0))).collect(Collectors.toMap(entry -> this.searchUtils.getFullAssetAttributeName((String)entry.getKey()), entry -> (String)((List)entry.getValue()).get(0)));
    }
}

