/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.view.PartPayload;

class ComponentUploadUtils {
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile(".*\\sname\\s*=['\"\\s]?([^'\";]+).*");
    private static final Pattern FILENAME_PATTERN = Pattern.compile(".*\\sfilename\\s*=['\"\\s]?([^'\";]+).*");
    private static final String ASSET_NAME_REGEX = "asset\\d*";

    private ComponentUploadUtils() {
    }

    private static Optional<String> extractValue(String header, Pattern fieldPattern, Optional<String> formatPrefix) {
        Matcher matcher = fieldPattern.matcher(header);
        if (matcher.matches()) {
            String value = matcher.group(1);
            if (formatPrefix.isPresent()) {
                value = value.replaceFirst("^" + formatPrefix.get() + "\\.", "");
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static Optional<String> extractFieldName(String format, String header) {
        return ComponentUploadUtils.extractValue(header, FIELD_NAME_PATTERN, Optional.of(format));
    }

    private static Optional<String> extractFilename(String header) {
        return ComponentUploadUtils.extractValue(header, FILENAME_PATTERN, Optional.empty());
    }

    static ComponentUpload createComponentUpload(String format, MultipartInput multipartInput) throws IOException {
        Map<String, InputStreamPartPayload> assetsPayloads = ComponentUploadUtils.getAssetsPayloads(format, multipartInput);
        Map<String, String> formFields = ComponentUploadUtils.getTextFormFields(format, multipartInput, assetsPayloads.keySet());
        HashMap assetFields = new HashMap();
        HashMap<String, String> componentFields = new HashMap<String, String>();
        formFields.forEach((key, value) -> {
            boolean isAssetField;
            int indexOfDot = key.indexOf(46);
            boolean bl = isAssetField = indexOfDot != -1 && key.length() > indexOfDot + 2 && assetsPayloads.containsKey(key.substring(0, indexOfDot));
            if (isAssetField) {
                String assetName = key.substring(0, indexOfDot);
                assetFields.putIfAbsent(assetName, new HashMap());
                ((Map)assetFields.get(assetName)).put(key.substring(indexOfDot + 1), value);
            } else {
                componentFields.put((String)key, (String)value);
            }
        });
        List<AssetUpload> assetUploads = assetsPayloads.entrySet().stream().map(asset -> ComponentUploadUtils.createAssetUpload((InputStreamPartPayload)asset.getValue(), (Map)assetFields.get(asset.getKey()))).collect(Collectors.toList());
        ComponentUpload componentUpload = new ComponentUpload();
        componentUpload.setFields(componentFields);
        componentUpload.setAssetUploads(assetUploads);
        return componentUpload;
    }

    private static AssetUpload createAssetUpload(InputStreamPartPayload assetPayload, Map<String, String> assetFields) {
        AssetUpload assetUpload = new AssetUpload();
        assetUpload.setPayload(assetPayload);
        assetUpload.setFields(assetFields);
        return assetUpload;
    }

    private static Map<String, String> getTextFormFields(String format, MultipartInput multipartInput, Set<String> assetNames) throws IOException {
        HashMap<String, String> fields = new HashMap<String, String>();
        List fieldsParts = multipartInput.getParts().stream().filter(part -> MediaType.TEXT_PLAIN_TYPE.isCompatible(part.getMediaType())).collect(Collectors.toList());
        for (InputPart inputPart : fieldsParts) {
            Optional<String> maybeFieldName;
            Optional<String> maybeContentDisposition = ComponentUploadUtils.getContentDisposition(inputPart);
            if (!maybeContentDisposition.isPresent() || !(maybeFieldName = ComponentUploadUtils.extractFieldName(format, maybeContentDisposition.get())).isPresent() || assetNames.contains(maybeFieldName.get())) continue;
            fields.put(maybeFieldName.get(), inputPart.getBodyAsString());
        }
        return fields;
    }

    private static Optional<String> getContentDisposition(InputPart inputPart) {
        return Optional.ofNullable((String)inputPart.getHeaders().getFirst((Object)"Content-Disposition"));
    }

    private static Map<String, InputStreamPartPayload> getAssetsPayloads(String format, MultipartInput multipartInput) throws IOException {
        HashMap<String, InputStreamPartPayload> payloads = new HashMap<String, InputStreamPartPayload>();
        for (InputPart inputPart : multipartInput.getParts()) {
            String fieldName;
            boolean isAsset;
            String contentDisposition;
            Optional<String> maybeFieldName;
            Optional<String> maybeContentDisposition = ComponentUploadUtils.getContentDisposition(inputPart);
            if (!maybeContentDisposition.isPresent() || !(maybeFieldName = ComponentUploadUtils.extractFieldName(format, contentDisposition = maybeContentDisposition.get())).isPresent() || !(isAsset = (fieldName = maybeFieldName.get()).matches(ASSET_NAME_REGEX))) continue;
            Optional<String> maybeFilename = ComponentUploadUtils.extractFilename(contentDisposition);
            InputStream inputStream = (InputStream)inputPart.getBody(InputStream.class, null);
            String filename = maybeFilename.orElse(null);
            String contentType = inputPart.getMediaType().toString();
            InputStreamPartPayload payload = new InputStreamPartPayload(filename, fieldName, inputStream, contentType);
            payloads.put(fieldName, payload);
        }
        return payloads;
    }

    private static class InputStreamPartPayload
    implements PartPayload {
        final String name;
        final String fieldName;
        final InputStream inputStream;
        final String contentType;

        InputStreamPartPayload(String name, String fieldName, InputStream inputStream, String contentType) {
            this.name = name;
            this.fieldName = fieldName;
            this.inputStream = inputStream;
            this.contentType = contentType;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public boolean isFormField() {
            return false;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public long getSize() {
            try {
                return this.inputStream.available();
            }
            catch (IOException iOException) {
                return 0L;
            }
        }

        @Override
        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

