/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.internal.resources.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;

@Named
public class RepositoryManagerRESTAdapterImpl
implements RepositoryManagerRESTAdapter {
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;

    @Inject
    public RepositoryManagerRESTAdapterImpl(RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = (RepositoryPermissionChecker)Preconditions.checkNotNull((Object)repositoryPermissionChecker);
    }

    @Override
    public Repository getRepository(String repositoryId) {
        if (repositoryId == null) {
            throw new WebApplicationException("repositoryId is required.", 422);
        }
        Repository repository = Optional.ofNullable(this.repositoryManager.get(repositoryId)).orElseThrow(() -> new NotFoundException("Unable to locate repository with id " + repositoryId));
        if (this.repositoryPermissionChecker.userCanBrowseRepository(repository)) {
            return repository;
        }
        throw new WebApplicationException(403);
    }

    @Override
    public List<Repository> getRepositories() {
        return this.repositoryPermissionChecker.userCanBrowseRepositories((Repository[])Iterables.toArray(this.repositoryManager.browse(), Repository.class));
    }
}

