/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.rest.SearchResourceExtension;
import org.sonatype.nexus.repository.rest.SearchUtils;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.ComponentXOFactory;
import org.sonatype.nexus.repository.rest.internal.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.internal.resources.AssetDownloadResponseProcessor;
import org.sonatype.nexus.repository.rest.internal.resources.AssetMapUtils;
import org.sonatype.nexus.repository.rest.internal.resources.TokenEncoder;
import org.sonatype.nexus.repository.rest.internal.resources.doc.SearchResourceDoc;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/search")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SearchResource
extends ComponentSupport
implements Resource,
SearchResourceDoc {
    public static final String RESOURCE_URI = "/v1/search";
    public static final String SEARCH_ASSET_URI = "/assets";
    public static final String SEARCH_AND_DOWNLOAD_URI = "/assets/download";
    private final SearchUtils searchUtils;
    private final AssetMapUtils assetMapUtils;
    private final BrowseService browseService;
    private final SearchService searchService;
    private final TokenEncoder tokenEncoder;
    private final ComponentXOFactory componentXOFactory;
    private final Set<SearchResourceExtension> searchResourceExtensions;
    private int pageSize = 50;

    @Inject
    public SearchResource(SearchUtils searchUtils, AssetMapUtils assetMapUtils, BrowseService browseService, SearchService searchService, TokenEncoder tokenEncoder, ComponentXOFactory componentXOFactory, Set<SearchResourceExtension> searchResourceExtensions) {
        this.searchUtils = (SearchUtils)((Object)Preconditions.checkNotNull((Object)((Object)searchUtils)));
        this.assetMapUtils = (AssetMapUtils)Preconditions.checkNotNull((Object)assetMapUtils);
        this.browseService = (BrowseService)Preconditions.checkNotNull((Object)browseService);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.tokenEncoder = (TokenEncoder)((Object)Preconditions.checkNotNull((Object)((Object)tokenEncoder)));
        this.componentXOFactory = (ComponentXOFactory)Preconditions.checkNotNull((Object)componentXOFactory);
        this.searchResourceExtensions = (Set)Preconditions.checkNotNull(searchResourceExtensions);
    }

    @Override
    @GET
    public Page<ComponentXO> search(@QueryParam(value="continuationToken") String continuationToken, @Context UriInfo uriInfo) {
        List componentXOs;
        QueryBuilder query = this.searchUtils.buildQuery(uriInfo);
        int from = this.tokenEncoder.decode(continuationToken, query);
        SearchResponse response = this.searchService.search(query, Collections.emptyList(), from, this.getPageSize());
        return new Page(componentXOs, (componentXOs = Arrays.stream(response.getHits().hits()).map(this::toComponent).collect(Collectors.toList())).size() == this.getPageSize() ? this.tokenEncoder.encode(from, this.getPageSize(), query) : null);
    }

    private ComponentXO toComponent(SearchHit hit) {
        Map source = (Map)Preconditions.checkNotNull((Object)hit.getSource());
        Repository repository = this.searchUtils.getRepository((String)source.get("repository_name"));
        ComponentXO componentXO = this.componentXOFactory.createComponentXO();
        componentXO.setAssets(this.browseService.browseComponentAssets(repository, hit.getId()).getResults().stream().map(asset -> AssetXO.fromAsset(asset, repository)).collect(Collectors.toList()));
        componentXO.setGroup((String)source.get("group"));
        componentXO.setName((String)source.get("name"));
        componentXO.setVersion((String)source.get("version"));
        componentXO.setId(new RepositoryItemIDXO(repository.getName(), hit.getId()).getValue());
        componentXO.setRepository(repository.getName());
        componentXO.setFormat(repository.getFormat().getValue());
        for (SearchResourceExtension searchResourceExtension : this.searchResourceExtensions) {
            componentXO = searchResourceExtension.updateComponentXO(componentXO, hit);
        }
        return componentXO;
    }

    @Override
    @GET
    @Path(value="/assets")
    public Page<AssetXO> searchAssets(@QueryParam(value="continuationToken") String continuationToken, @Context UriInfo uriInfo) {
        QueryBuilder query = this.searchUtils.buildQuery(uriInfo);
        int from = this.tokenEncoder.decode(continuationToken, query);
        SearchResponse componentResponse = this.searchService.search(query, Collections.emptyList(), from, this.getPageSize());
        List<AssetXO> assetXOs = this.retrieveAssets(componentResponse, uriInfo);
        return new Page(assetXOs, componentResponse.getHits().hits().length == this.getPageSize() ? this.tokenEncoder.encode(from, this.getPageSize(), query) : null);
    }

    @Override
    @GET
    @Path(value="/assets/download")
    public Response searchAndDownloadAssets(@Context UriInfo uriInfo) {
        QueryBuilder query = this.searchUtils.buildQuery(uriInfo);
        List<AssetXO> assetXOs = this.retrieveAssets(query, uriInfo);
        return new AssetDownloadResponseProcessor(assetXOs).process();
    }

    private List<AssetXO> retrieveAssets(SearchResponse response, UriInfo uriInfo) {
        MultivaluedMap<String, String> assetParams = this.getAssetParams(uriInfo);
        return Arrays.stream(response.getHits().hits()).flatMap(hit -> this.extractAssets((SearchHit)hit, assetParams)).collect(Collectors.toList());
    }

    private List<AssetXO> retrieveAssets(QueryBuilder query, UriInfo uriInfo, int from) {
        return this.retrieveAssets(this.searchService.search(query, Collections.emptyList(), from, this.getPageSize()), uriInfo);
    }

    private List<AssetXO> retrieveAssets(QueryBuilder query, UriInfo uriInfo) {
        return this.retrieveAssets(query, uriInfo, 0);
    }

    private Stream<AssetXO> extractAssets(SearchHit componentHit, MultivaluedMap<String, String> assetParams) {
        Map componentMap = (Map)Preconditions.checkNotNull((Object)componentHit.getSource());
        Repository repository = this.searchUtils.getRepository((String)componentMap.get("repository_name"));
        List assets = (List)componentMap.get("assets");
        if (assets == null) {
            return Stream.empty();
        }
        return assets.stream().filter(assetMap -> this.assetMapUtils.filterAsset((Map<String, Object>)assetMap, assetParams)).map(asset -> AssetXO.fromElasticSearchMap(asset, repository));
    }

    @VisibleForTesting
    MultivaluedMap<String, String> getAssetParams(UriInfo uriInfo) {
        return (MultivaluedMap)uriInfo.getQueryParameters().entrySet().stream().filter(t -> this.searchUtils.isAssetSearchParam((String)t.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, MultivaluedHashMap::new));
    }

    private int getPageSize() {
        return this.pageSize;
    }

    @VisibleForTesting
    void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

