/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import org.elasticsearch.index.query.QueryBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.Hex;

@Singleton
@Named
public class TokenEncoder
extends ComponentSupport {
    int decode(@Nullable String continuationToken, QueryBuilder query) {
        if (continuationToken == null) {
            return 0;
        }
        String decoded = new String(Hex.decode((String)continuationToken), StandardCharsets.UTF_8);
        String[] decodedParts = decoded.split(":");
        if (decodedParts.length != 2) {
            throw new WebApplicationException(String.format("Unable to parse token %s", continuationToken), 406);
        }
        if (!decodedParts[1].equals(this.getHashCode(query))) {
            throw new WebApplicationException(String.format("Continuation token %s does not match this query", continuationToken), 406);
        }
        return Integer.parseInt(decodedParts[0]);
    }

    String encode(int lastFrom, int pageSize, QueryBuilder query) {
        int index = lastFrom + pageSize;
        return Hex.encode((byte[])String.format("%s:%s", Integer.toString(index), this.getHashCode(query)).getBytes(StandardCharsets.UTF_8));
    }

    private String getHashCode(QueryBuilder query) {
        return HashAlgorithm.MD5.function().hashString((CharSequence)query.toString(), StandardCharsets.UTF_8).toString();
    }
}

