/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.api.UploadDefinitionXO;
import org.sonatype.nexus.repository.rest.api.UploadFieldDefinitionXO;
import org.sonatype.nexus.repository.rest.internal.resources.doc.UploadDefinitionResourceDoc;
import org.sonatype.nexus.repository.upload.UploadConfiguration;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/formats")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UploadDefinitionResource
extends ComponentSupport
implements Resource,
UploadDefinitionResourceDoc {
    public static final String BASE_PATH = "/v1/formats";
    private final UploadManager uploadManager;
    private final UploadConfiguration uploadConfiguration;

    @Inject
    public UploadDefinitionResource(UploadManager uploadManager, UploadConfiguration uploadConfiguration) {
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.uploadConfiguration = (UploadConfiguration)Preconditions.checkNotNull((Object)uploadConfiguration);
    }

    @Override
    @Path(value="upload-specs")
    @GET
    public List<UploadDefinitionXO> get() {
        this.log.debug("Get upload definitions for all formats.");
        if (!this.uploadConfiguration.isEnabled()) {
            this.log.debug("Upload is disabled.");
            throw new NotFoundException();
        }
        return this.uploadManager.getAvailableDefinitions().stream().map(this::from).collect(Collectors.toList());
    }

    @Override
    @Path(value="{format}/upload-specs")
    @GET
    public UploadDefinitionXO get(@PathParam(value="format") String format) {
        this.log.debug("Get upload definition for format '{}'.", (Object)format);
        if (!this.uploadConfiguration.isEnabled()) {
            this.log.debug("Upload is disabled.");
            throw new NotFoundException();
        }
        UploadDefinition uploadDefinition = this.uploadManager.getByFormat(format);
        if (uploadDefinition == null) {
            this.log.debug("Could not find upload definition for format '{}'.", (Object)format);
            throw new NotFoundException(String.format("Unable to locate upload definition for format '%s'", format));
        }
        return this.from(uploadDefinition);
    }

    private UploadDefinitionXO from(UploadDefinition def) {
        UploadDefinitionXO xo = UploadDefinitionXO.from(def);
        UploadFieldDefinitionXO fieldXo = new UploadFieldDefinitionXO();
        fieldXo.setName("asset");
        fieldXo.setType("FILE");
        fieldXo.setOptional(false);
        xo.getAssetFields().add(fieldXo);
        return xo;
    }
}

