/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.rest.Page;

@Api(value="assets", description="Operations to get and delete assets")
public interface AssetsResourceDoc {
    @ApiOperation(value="List assets")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to list assets"), @ApiResponse(code=422, message="Parameter 'repository' is required")})
    public Page<AssetXO> getAssets(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned") String var1, @ApiParam(value="Repository from which you would like to retrieve assets.", required=true) String var2);

    @ApiOperation(value="Get a single asset")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to get asset"), @ApiResponse(code=404, message="Asset not found"), @ApiResponse(code=422, message="Malformed ID")})
    public AssetXO getAssetById(@ApiParam(value="Id of the asset to get") String var1);

    @ApiOperation(value="Delete a single asset")
    @ApiResponses(value={@ApiResponse(code=204, message="Asset was successfully deleted"), @ApiResponse(code=403, message="Insufficient permissions to delete asset"), @ApiResponse(code=404, message="Asset not found"), @ApiResponse(code=422, message="Malformed ID")})
    public void deleteAsset(@ApiParam(value="Id of the asset to delete") String var1);
}

