/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources.doc;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.rest.Page;

@Api(value="components")
public interface ComponentsResourceDoc {
    @ApiOperation(value="List components")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to list components"), @ApiResponse(code=422, message="Parameter 'repository' is required")})
    public Page<ComponentXO> getComponents(@ApiParam(value="A token returned by a prior request. If present, the next page of results are returned") String var1, @ApiParam(value="Repository from which you would like to retrieve components", required=true) String var2);

    @ApiOperation(value="Get a single component")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to get component"), @ApiResponse(code=404, message="Component not found"), @ApiResponse(code=422, message="Malformed ID")})
    public ComponentXO getComponentById(@ApiParam(value="ID of the component to retrieve") String var1);

    @ApiOperation(value="Delete a single component")
    @ApiResponses(value={@ApiResponse(code=204, message="Component was successfully deleted"), @ApiResponse(code=403, message="Insufficient permissions to delete component"), @ApiResponse(code=404, message="Component not found"), @ApiResponse(code=422, message="Malformed ID")})
    public void deleteComponent(@ApiParam(value="ID of the component to delete") String var1);

    @ApiOperation(value="Upload a single component")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to upload a component"), @ApiResponse(code=422, message="Parameter 'repository' is required")})
    public void uploadComponent(@ApiParam(value="Name of the repository to which you would like to upload the component", required=true) String var1, @ApiParam(hidden=true) @MultipartForm MultipartInput var2) throws IOException;
}

