/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.nexus.repository.search.SearchContributionSupport;

@Named(value="default")
@Singleton
public class DefaultSearchContribution
extends SearchContributionSupport {
    public static final String NAME = "default";
    private static final String UNESCAPED_SLASHES = "([^\\\\\\\\])(/)";

    @Override
    public void contribute(BoolQueryBuilder query, String type, String value) {
        if (value != null) {
            String escaped = value.replaceAll(UNESCAPED_SLASHES, "$1\\\\/");
            if (escaped.startsWith("/")) {
                escaped = "\\" + escaped;
            }
            query.must((QueryBuilder)QueryBuilders.queryStringQuery((String)escaped).field(type).lowercaseExpandedTerms(false));
        }
    }
}

