/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.SearchResultComponent;
import org.sonatype.nexus.repository.search.SearchResultComponentGeneratorSupport;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

@Singleton
@Named
public class DefaultSearchResultComponentGenerator
extends SearchResultComponentGeneratorSupport {
    public static final String DEFAULT_SEARCH_RESULT_COMPONENT_GENERATOR_KEY = "default";

    @Inject
    public DefaultSearchResultComponentGenerator(VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker) {
        super(variableResolverAdapterManager, repositoryManager, contentPermissionChecker);
    }

    @Override
    public SearchResultComponent from(SearchHit hit, Set<String> componentIdSet) {
        SearchResultComponent component = new SearchResultComponent();
        Map source = hit.getSource();
        component.setId(hit.getId());
        component.setRepositoryName(this.getPrivilegedRepositoryName(source));
        component.setGroup((String)source.get("group"));
        component.setName((String)source.get("name"));
        component.setVersion((String)source.get("version"));
        component.setFormat((String)source.get("format"));
        return component;
    }
}

