/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.EntityBatchEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.search.IndexRequest;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEvent;

public final class IndexBatchRequest {
    private final Map<String, IndexRequest> requests = new HashMap<String, IndexRequest>();
    private final Set<EntityId> pendingDeletes = new HashSet<EntityId>();

    public IndexBatchRequest(EntityBatchEvent batchEvent) {
        for (EntityEvent event : batchEvent.getEvents()) {
            if (event instanceof ComponentEvent) {
                this.consume((ComponentEvent)event);
                continue;
            }
            if (!(event instanceof AssetEvent)) continue;
            this.consume((AssetEvent)event);
        }
    }

    public IndexBatchRequest() {
    }

    public void update(String repositoryName, EntityId componentId) {
        this.request(repositoryName).update(componentId);
    }

    public void delete(@Nullable String repositoryName, EntityId componentId) {
        if (repositoryName != null) {
            this.request(repositoryName).update(componentId);
        }
        this.pendingDeletes.add(componentId);
    }

    Set<EntityId> apply(BiConsumer<String, IndexRequest> consumer) {
        this.requests.forEach(consumer);
        return this.pendingDeletes;
    }

    private void consume(ComponentEvent event) {
        if (event instanceof ComponentDeletedEvent) {
            this.delete(event.getRepositoryName(), event.getComponentId());
        } else {
            this.update(event.getRepositoryName(), event.getComponentId());
        }
    }

    private void consume(AssetEvent event) {
        if (event.getComponentId() != null) {
            this.update(event.getRepositoryName(), event.getComponentId());
        }
    }

    private IndexRequest request(String repositoryName) {
        IndexRequest request = this.requests.get(repositoryName);
        if (request == null) {
            request = new IndexRequest(this.pendingDeletes);
            this.requests.put(repositoryName, request);
        }
        return request;
    }
}

