/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.search.SearchFacet;

final class IndexRequest {
    private final Set<EntityId> pendingDeletes;
    private final Set<EntityId> updatedIds = new HashSet<EntityId>();

    IndexRequest(Set<EntityId> pendingDeletes) {
        this.pendingDeletes = (Set)Preconditions.checkNotNull(pendingDeletes);
    }

    void update(EntityId componentId) {
        this.updatedIds.add(componentId);
    }

    void apply(SearchFacet searchFacet) {
        this.updatedIds.forEach(id -> {
            if (this.pendingDeletes.remove(id)) {
                searchFacet.delete((EntityId)id);
            } else {
                searchFacet.put((EntityId)id);
            }
        });
    }

    void bulkApply(SearchFacet searchFacet) {
        if (!this.pendingDeletes.isEmpty()) {
            HashSet<EntityId> deletedIds = new HashSet<EntityId>();
            Iterator<EntityId> itr = this.updatedIds.iterator();
            while (itr.hasNext()) {
                EntityId id = itr.next();
                if (!this.pendingDeletes.remove(id)) continue;
                deletedIds.add(id);
                itr.remove();
            }
            if (!deletedIds.isEmpty()) {
                searchFacet.bulkDelete(deletedIds);
            }
        }
        if (!this.updatedIds.isEmpty()) {
            searchFacet.bulkPut(this.updatedIds);
        }
    }
}

