/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.entity.EntityBatchEvent;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.InvalidStateException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.IndexBatchRequest;
import org.sonatype.nexus.repository.search.IndexRequest;
import org.sonatype.nexus.repository.search.SearchFacet;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class IndexRequestProcessor
extends LifecycleSupport
implements EventAware.Asynchronous {
    private final RepositoryManager repositoryManager;
    private final EventManager eventManager;
    private final SearchService searchService;
    private final boolean bulkProcessing;
    private boolean processEvents = true;

    @Inject
    public IndexRequestProcessor(RepositoryManager repositoryManager, EventManager eventManager, SearchService searchService, @Named(value="${nexus.elasticsearch.bulkProcessing:-true}") boolean bulkProcessing) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.bulkProcessing = bulkProcessing;
    }

    protected void doStart() {
        this.eventManager.register((Object)this);
    }

    protected void doStop() {
        this.eventManager.unregister((Object)this);
        this.searchService.flush(true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(EntityBatchEvent batchEvent) {
        this.process(new IndexBatchRequest(batchEvent));
    }

    public void process(IndexBatchRequest request) {
        if (!this.processEvents) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skip processing of EntityBatchEvent, IndexRequestProcessor is disabled");
            }
            return;
        }
        Set<EntityId> pendingDeletes = request.apply(this::maybeUpdateSearchIndex);
        if (!pendingDeletes.isEmpty()) {
            this.searchService.bulkDelete(null, Iterables.transform(pendingDeletes, EntityId::getValue));
        }
    }

    public void setProcessEvents(boolean processEvents) {
        this.processEvents = processEvents;
    }

    private void maybeUpdateSearchIndex(String repositoryName, IndexRequest indexRequest) {
        block13: {
            Repository repository = this.repositoryManager.get(repositoryName);
            if (repository == null) break block13;
            try {
                this.doUpdateSearchIndex(repository, indexRequest);
            }
            catch (InvalidStateException e) {
                switch (e.getInvalidState()) {
                    case "DELETED": 
                    case "STOPPED": 
                    case "DESTROYED": {
                        this.log.debug("Ignoring async search update for {} repository {}", new Object[]{e.getInvalidState(), repositoryName, e});
                    }
                    default: {
                        throw e;
                    }
                }
            }
        }
        this.log.debug("Ignoring async search update for missing repository {}", (Object)repositoryName);
    }

    private void doUpdateSearchIndex(Repository repository, IndexRequest indexRequest) {
        repository.optionalFacet(SearchFacet.class).ifPresent(searchFacet -> {
            UnitOfWork.begin(repository.facet(StorageFacet.class).txSupplier());
            try {
                if (this.bulkProcessing) {
                    indexRequest.bulkApply((SearchFacet)searchFacet);
                } else {
                    indexRequest.apply((SearchFacet)searchFacet);
                }
            }
            finally {
                UnitOfWork.end();
            }
        });
    }
}

