/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;

class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static String from(Object value) throws IOException {
        return objectWriter.writeValueAsString(value);
    }

    public static String merge(String ... jsons) throws IOException {
        ObjectNode merged = objectMapper.createObjectNode();
        String[] stringArray = jsons;
        int n = jsons.length;
        int n2 = 0;
        while (n2 < n) {
            String json = stringArray[n2];
            merged = JsonUtils.merge((JsonNode)merged, objectMapper.readTree(json));
            ++n2;
        }
        return objectWriter.writeValueAsString((Object)merged);
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                JsonUtils.merge(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mainNode).set(fieldName, value);
        }
        return mainNode;
    }
}

