/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.sonatype.nexus.repository.search.SearchContributionSupport;

@Named(value="keyword")
@Singleton
public class KeywordSearchContribution
extends SearchContributionSupport {
    public static final String NAME = "keyword";
    private Pattern dependencyPattern = Pattern.compile("^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$");

    @Override
    public void contribute(BoolQueryBuilder query, String type, String value) {
        boolean hasKeywordSearch;
        if (value == null) {
            return;
        }
        Matcher gavSearchMatcher = this.dependencyPattern.matcher(value.trim());
        boolean hasGavSearch = gavSearchMatcher.matches();
        QueryStringQueryBuilder keywordQuery = QueryBuilders.queryStringQuery((String)value).field("name.case_insensitive").field("group.case_insensitive").field("_all");
        BoolQueryBuilder gavQuery = QueryBuilders.boolQuery();
        if (hasGavSearch) {
            String group = gavSearchMatcher.group("group");
            String name = gavSearchMatcher.group("name");
            String version = gavSearchMatcher.group("version");
            String extension = gavSearchMatcher.group("extension");
            String classifier = gavSearchMatcher.group("classifier");
            this.buildGavQuery(gavQuery, group, name, version, extension, classifier);
            hasKeywordSearch = version == null;
            keywordQuery.lenient(Boolean.valueOf(true));
        } else {
            hasKeywordSearch = true;
        }
        if (hasKeywordSearch && !hasGavSearch) {
            query.must((QueryBuilder)keywordQuery);
        } else if (!hasKeywordSearch && hasGavSearch) {
            query.must((QueryBuilder)gavQuery);
        } else {
            query.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)keywordQuery).should((QueryBuilder)gavQuery));
        }
    }

    private void buildGavQuery(BoolQueryBuilder gavQuery, String group, String name, String version, String extension, String classifier) {
        if (group != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"group.raw", (String)group));
        }
        if (name != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"name.raw", (String)name));
        }
        if (version != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"version", (String)version));
        }
        if (extension != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"assets.attributes.maven2.extension", (String)extension));
        }
        if (classifier != null) {
            gavQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"assets.attributes.maven2.classifier", (String)classifier));
        }
    }
}

