/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.DefaultSearchContribution;

@Named(value="repository_name")
@Singleton
public class RepositorySearchContribution
extends DefaultSearchContribution {
    public static final String NAME = "repository_name";
    private final RepositoryManager repositoryManager;

    @Inject
    public RepositorySearchContribution(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void contribute(BoolQueryBuilder query, String type, String value) {
        Optional<GroupFacet> groupFacet;
        if (value == null) {
            return;
        }
        Repository repository = this.repositoryManager.get(value);
        if (repository != null && (groupFacet = repository.optionalFacet(GroupFacet.class)).isPresent()) {
            List<Repository> members = groupFacet.get().leafMembers();
            query.must((QueryBuilder)QueryBuilders.termsQuery((String)type, (String[])((String[])members.stream().map(Repository::getName).toArray(String[]::new))));
            return;
        }
        super.contribute(query, type, value);
    }
}

