/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.search.ComponentMetadataProducer;
import org.sonatype.nexus.repository.search.SearchFacet;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class SearchFacetImpl
extends FacetSupport
implements SearchFacet {
    private static final String COMPONENTS_IN_BUCKET = String.format("select from %s where %s = :bucket", ComponentEntityAdapter.DB_CLASS, "bucket");
    private final SearchService searchService;
    private final Map<String, ComponentMetadataProducer> componentMetadataProducers;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final BucketEntityAdapter bucketEntityAdapter;
    private Map<String, Object> repositoryMetadata;

    @Inject
    public SearchFacetImpl(SearchService searchService, Map<String, ComponentMetadataProducer> componentMetadataProducers, ComponentEntityAdapter componentEntityAdapter, BucketEntityAdapter bucketEntityAdapter) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.componentMetadataProducers = (Map)Preconditions.checkNotNull(componentMetadataProducers);
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
    }

    @Override
    protected void doInit(Configuration configuration) throws Exception {
        this.repositoryMetadata = ImmutableMap.of((Object)"repository_name", (Object)this.getRepository().getName());
        super.doInit(configuration);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void rebuildIndex() {
        this.log.info("Rebuilding index of repository {}", (Object)this.getRepository().getName());
        this.searchService.rebuildIndex(this.getRepository());
        UnitOfWork.begin(this.facet(StorageFacet.class).txSupplier());
        try {
            this.rebuildComponentIndex();
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional
    protected void rebuildComponentIndex() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        if (bucket != null) {
            ORID bucketId = this.bucketEntityAdapter.recordIdentity((Entity)bucket);
            Iterable<ODocument> docs = tx.browse(COMPONENTS_IN_BUCKET, (Map<String, Object>)ImmutableMap.of((Object)"bucket", (Object)bucketId));
            this.bulkPut(Iterables.transform((Iterable)Iterables.filter(docs, Objects::nonNull), this::componentId));
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void put(EntityId componentId) {
        Preconditions.checkNotNull((Object)componentId);
        String json = this.json(componentId);
        if (json != null) {
            this.searchService.put(this.getRepository(), this.identifier(componentId), json);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void bulkPut(Iterable<EntityId> componentIds) {
        Preconditions.checkNotNull(componentIds);
        this.searchService.bulkPut(this.getRepository(), componentIds, this::identifier, this::json);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(EntityId componentId) {
        Preconditions.checkNotNull((Object)componentId);
        this.searchService.delete(this.getRepository(), this.identifier(componentId));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void bulkDelete(Iterable<EntityId> componentIds) {
        Preconditions.checkNotNull(componentIds);
        this.searchService.bulkDelete(this.getRepository(), Iterables.transform(componentIds, this::identifier));
    }

    @Override
    protected void doStart() throws Exception {
        this.searchService.createIndex(this.getRepository());
    }

    @Override
    protected void doDelete() {
        this.searchService.deleteIndex(this.getRepository());
    }

    @Nullable
    private EntityId componentId(@Nullable ODocument doc) {
        return doc != null ? new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, doc.getIdentity()) : null;
    }

    private ComponentMetadataProducer producer(Component component) {
        Preconditions.checkNotNull((Object)component);
        String format = component.format();
        ComponentMetadataProducer producer = this.componentMetadataProducers.get(format);
        if (producer == null) {
            producer = this.componentMetadataProducers.get("default");
        }
        Preconditions.checkState((producer != null ? 1 : 0) != 0, (String)"Could not find a component metadata producer for format: %s", (Object)format);
        return producer;
    }

    @Nullable
    private String identifier(@Nullable EntityId componentId) {
        return componentId != null ? componentId.getValue() : null;
    }

    @Nullable
    @Transactional
    protected String json(@Nullable EntityId componentId) {
        StorageTx tx;
        Component component;
        if (componentId != null && (component = (Component)this.componentEntityAdapter.read((tx = (StorageTx)UnitOfWork.currentTx()).getDb(), componentId)) != null) {
            Iterable<Asset> assets = tx.browseAssets(component);
            return this.producer(component).getMetadata(component, assets, this.repositoryMetadata);
        }
        return null;
    }
}

