/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.SearchResultComponentGenerator;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;

public abstract class SearchResultComponentGeneratorSupport
extends ComponentSupport
implements SearchResultComponentGenerator {
    final VariableResolverAdapterManager variableResolverAdapterManager;
    final RepositoryManager repositoryManager;
    final ContentPermissionChecker contentPermissionChecker;

    public SearchResultComponentGeneratorSupport(VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker) {
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
    }

    protected String getPrivilegedRepositoryName(Map<String, Object> source) {
        String repositoryName = (String)source.get("repository_name");
        String repositoryFormat = (String)source.get("format");
        List assets = source.getOrDefault("assets", Collections.emptyList());
        SourceLookup lookup = new SourceLookup();
        lookup.setSource(source);
        if (assets != null && !assets.isEmpty()) {
            VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(repositoryFormat);
            VariableSource variableSource = variableResolverAdapter.fromSourceLookup(lookup, (Map)assets.get(0));
            List<String> repositoryNames = this.repositoryManager.findContainingGroups(repositoryName);
            repositoryNames.add(0, repositoryName);
            for (String name : repositoryNames) {
                if (!this.contentPermissionChecker.isPermitted(name, repositoryFormat, "browse", variableSource)) continue;
                return name;
            }
        }
        return null;
    }
}

