/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.search.SearchResultComponent;
import org.sonatype.nexus.repository.search.SearchResultComponentGenerator;
import org.sonatype.nexus.repository.search.SearchResultsGenerator;

@Named
@Singleton
public class SearchResultsGeneratorImpl
implements SearchResultsGenerator {
    private final Map<String, SearchResultComponentGenerator> searchResultComponentGeneratorMap;
    private final SearchResultComponentGenerator defaultSearchResultComponentGenerator;

    @Inject
    SearchResultsGeneratorImpl(Map<String, SearchResultComponentGenerator> searchResultComponentGeneratorMap) {
        this.searchResultComponentGeneratorMap = searchResultComponentGeneratorMap;
        this.defaultSearchResultComponentGenerator = searchResultComponentGeneratorMap.get("default");
    }

    @Override
    public List<SearchResultComponent> getSearchResultList(SearchResponse response) {
        ArrayList<SearchResultComponent> searchResultComponents = new ArrayList<SearchResultComponent>((int)response.getHits().getTotalHits());
        HashSet<String> componentIdSet = new HashSet<String>();
        SearchHit[] searchHitArray = response.getHits().getHits();
        int n = searchHitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            Map source = hit.getSource();
            String format = source.get("format").toString();
            SearchResultComponentGenerator generator = this.searchResultComponentGeneratorMap.getOrDefault(format, this.defaultSearchResultComponentGenerator);
            SearchResultComponent component = generator.from(hit, componentIdSet);
            if (component != null) {
                componentIdSet.add(component.getId());
                searchResultComponents.add(component);
            }
            ++n2;
        }
        return searchResultComponents;
    }
}

