/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.ScriptQueryBuilder;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.sort.SortBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.BulkIndexUpdateListener;
import org.sonatype.nexus.repository.search.IndexSettingsContributor;
import org.sonatype.nexus.repository.search.JsonUtils;
import org.sonatype.nexus.repository.search.SearchFacet;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SearchSubjectHelper;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.selector.internal.ContentAuthPluginScriptFactory;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
public class SearchServiceImpl
extends ComponentSupport
implements SearchService {
    private static final String TYPE = "component";
    public static final String MAPPING_JSON = "elasticsearch-mapping.json";
    private static final SearchResponse EMPTY_SEARCH_RESPONSE = new SearchResponse(InternalSearchResponse.empty(), null, 0, 0, 0L, new ShardSearchFailure[0]);
    private final Provider<Client> client;
    private final RepositoryManager repositoryManager;
    private final SecurityHelper securityHelper;
    private final SearchSubjectHelper searchSubjectHelper;
    private final List<IndexSettingsContributor> indexSettingsContributors;
    private final ConcurrentMap<String, String> repositoryNameMapping;
    private final BulkIndexUpdateListener updateListener;
    private final boolean profile;
    private final boolean periodicFlush;
    private BulkProcessor bulkProcessor;

    @Inject
    public SearchServiceImpl(Provider<Client> client, RepositoryManager repositoryManager, SecurityHelper securityHelper, SearchSubjectHelper searchSubjectHelper, List<IndexSettingsContributor> indexSettingsContributors, @Named(value="${nexus.elasticsearch.profile:-false}") boolean profile, @Named(value="${nexus.elasticsearch.bulkCapacity:-1000}") int bulkCapacity, @Named(value="${nexus.elasticsearch.concurrentRequests:-1}") int concurrentRequests, @Named(value="${nexus.elasticsearch.flushInterval:-0}") int flushInterval) {
        this.client = (Provider)Preconditions.checkNotNull(client);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.searchSubjectHelper = (SearchSubjectHelper)((Object)Preconditions.checkNotNull((Object)((Object)searchSubjectHelper)));
        this.indexSettingsContributors = (List)Preconditions.checkNotNull(indexSettingsContributors);
        this.repositoryNameMapping = Maps.newConcurrentMap();
        this.updateListener = new BulkIndexUpdateListener();
        this.profile = profile;
        this.periodicFlush = flushInterval > 0;
        this.bulkProcessor = BulkProcessor.builder((Client)((Client)client.get()), (BulkProcessor.Listener)this.updateListener).setBulkActions(bulkCapacity).setBulkSize(new ByteSizeValue(-1L)).setConcurrentRequests(concurrentRequests).setFlushInterval(this.periodicFlush ? TimeValue.timeValueMillis((long)flushInterval) : null).build();
    }

    @Override
    public void flush(boolean fsync) {
        this.log.debug("Flushing index requests");
        this.bulkProcessor.flush();
        if (fsync) {
            try {
                this.indicesAdminClient().prepareSyncedFlush(new String[0]).execute().actionGet();
            }
            catch (RuntimeException e) {
                this.log.warn("Problem flushing search indices", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isCalmPeriod() {
        if (this.updateListener.inflightRequestCount() > 0) {
            return false;
        }
        try {
            this.indicesAdminClient().prepareRefresh(new String[0]).execute().actionGet();
        }
        catch (RuntimeException e) {
            this.log.warn("Problem refreshing search indices", (Throwable)e);
        }
        return true;
    }

    @Override
    public void createIndex(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String safeIndexName = HashAlgorithm.SHA1.function().hashUnencodedChars((CharSequence)repository.getName()).toString();
        this.log.debug("Creating index for {}", (Object)repository);
        this.createIndex(repository, safeIndexName);
    }

    private void createIndex(Repository repository, String indexName) {
        IndicesAdminClient indices = this.indicesAdminClient();
        if (!((IndicesExistsResponse)indices.prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
            ArrayList urls = Lists.newArrayListWithExpectedSize((int)(this.indexSettingsContributors.size() + 1));
            urls.add(Resources.getResource(this.getClass(), (String)MAPPING_JSON));
            for (IndexSettingsContributor contributor : this.indexSettingsContributors) {
                URL url = contributor.getIndexSettings(repository);
                if (url == null) continue;
                urls.add(url);
            }
            try {
                String source = "{}";
                for (URL url : urls) {
                    this.log.debug("Merging ElasticSearch mapping: {}", (Object)url);
                    String contributed = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                    this.log.trace("Contributed ElasticSearch mapping: {}", (Object)contributed);
                    source = JsonUtils.merge(source, contributed);
                }
                this.log.trace("ElasticSearch mapping: {}", (Object)source);
                indices.prepareCreate(indexName).setSource(source).execute().actionGet();
            }
            catch (IndexAlreadyExistsException e) {
                this.log.debug("Using existing index for {}", (Object)repository, (Object)e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.repositoryNameMapping.put(repository.getName(), indexName);
    }

    @Override
    public void deleteIndex(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String indexName = (String)this.repositoryNameMapping.remove(repository.getName());
        if (indexName != null) {
            this.log.debug("Removing index of {}", (Object)repository);
            this.deleteIndex(indexName);
        }
    }

    private void deleteIndex(String indexName) {
        this.bulkProcessor.flush();
        IndicesAdminClient indices = this.indicesAdminClient();
        if (((IndicesExistsResponse)indices.prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
            indices.prepareDelete(new String[]{indexName}).execute().actionGet();
        }
    }

    @Override
    public void rebuildIndex(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String indexName = (String)this.repositoryNameMapping.remove(repository.getName());
        if (indexName != null) {
            this.log.debug("Rebuilding index for {}", (Object)repository);
            this.deleteIndex(indexName);
            this.createIndex(repository, indexName);
        }
    }

    @Override
    public void put(Repository repository, final String identifier, String json) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)json);
        final String indexName = (String)this.repositoryNameMapping.get(repository.getName());
        if (indexName == null) {
            return;
        }
        this.log.debug("Adding to index document {} from {}: {}", new Object[]{identifier, repository, json});
        ((Client)this.client.get()).prepareIndex(indexName, TYPE, identifier).setSource(json).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                SearchServiceImpl.this.log.debug("successfully added {} {} to index {}", new Object[]{SearchServiceImpl.TYPE, identifier, indexName, indexResponse});
            }

            public void onFailure(Throwable e) {
                SearchServiceImpl.this.log.error("failed to add {} {} to index {}; this is a sign that the Elasticsearch index thread pool is overloaded", new Object[]{SearchServiceImpl.TYPE, identifier, indexName, e});
            }
        });
    }

    @Override
    public <T> void bulkPut(Repository repository, Iterable<T> components, Function<T, String> identifierProducer, Function<T, String> jsonDocumentProducer) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(components);
        String indexName = (String)this.repositoryNameMapping.get(repository.getName());
        if (indexName == null) {
            return;
        }
        components.forEach(component -> {
            CancelableHelper.checkCancellation();
            String identifier = (String)identifierProducer.apply(component);
            String json = (String)jsonDocumentProducer.apply(component);
            if (json != null) {
                this.log.debug("Bulk adding to index document {} from {}: {}", new Object[]{identifier, repository, json});
                this.bulkProcessor.add((IndexRequest)((Client)this.client.get()).prepareIndex(indexName, TYPE, identifier).setSource(json).request());
            }
        });
        if (!this.periodicFlush) {
            this.bulkProcessor.flush();
        }
    }

    @Override
    public void delete(Repository repository, final String identifier) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)identifier);
        final String indexName = (String)this.repositoryNameMapping.get(repository.getName());
        if (indexName == null) {
            return;
        }
        this.log.debug("Removing from index document {} from {}", (Object)identifier, (Object)repository);
        ((Client)this.client.get()).prepareDelete(indexName, TYPE, identifier).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                SearchServiceImpl.this.log.debug("successfully removed {} {} from index {}", new Object[]{SearchServiceImpl.TYPE, identifier, indexName, deleteResponse});
            }

            public void onFailure(Throwable e) {
                SearchServiceImpl.this.log.error("failed to remove {} {} from index {}; this is a sign that the Elasticsearch index thread pool is overloaded", new Object[]{SearchServiceImpl.TYPE, identifier, indexName, e});
            }
        });
    }

    @Override
    public void bulkDelete(@Nullable Repository repository, Iterable<String> identifiers) {
        Preconditions.checkNotNull(identifiers);
        if (repository != null) {
            String indexName = (String)this.repositoryNameMapping.get(repository.getName());
            if (indexName == null) {
                return;
            }
            identifiers.forEach(id -> {
                this.log.debug("Bulk removing from index document {} from {}", id, (Object)repository);
                this.bulkProcessor.add((DeleteRequest)((Client)this.client.get()).prepareDelete(indexName, TYPE, id).request());
            });
        } else {
            Iterables.partition(identifiers, (int)100).forEach(chunk -> {
                SearchResponse toDelete = (SearchResponse)((Client)this.client.get()).prepareSearch(new String[]{"_all"}).setFetchSource(false).setQuery((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{TYPE}).ids((Collection)chunk)).setSize(chunk.size()).execute().actionGet();
                toDelete.getHits().forEach(hit -> {
                    this.log.debug("Bulk removing from index document {} from {}", (Object)hit.getId(), (Object)hit.index());
                    this.bulkProcessor.add((DeleteRequest)((Client)this.client.get()).prepareDelete(hit.index(), TYPE, hit.getId()).request());
                });
            });
        }
        if (!this.periodicFlush) {
            this.bulkProcessor.flush();
        }
    }

    @Override
    public Iterable<SearchHit> browseUnrestricted(QueryBuilder query) {
        return this.browseUnrestrictedInRepos(query, null);
    }

    @Override
    public Iterable<SearchHit> browseUnrestrictedInRepos(QueryBuilder query, @Nullable Collection<String> repoNames) {
        return this.browse(query, repoNames, false, true);
    }

    @Override
    public Iterable<SearchHit> browse(QueryBuilder query) {
        return this.browse(query, null, true, false);
    }

    private Iterable<SearchHit> browse(QueryBuilder query, @Nullable Collection<String> repoNames, boolean skipContentPermForIndexes, boolean skipContentPermForSearch) {
        Preconditions.checkNotNull((Object)query);
        try {
            if (!((ValidateQueryResponse)this.indicesAdminClient().prepareValidateQuery(new String[0]).setQuery(query).execute().actionGet()).isValid()) {
                throw new IllegalArgumentException("Invalid query");
            }
        }
        catch (IndexNotFoundException indexNotFoundException) {
            return Collections.emptyList();
        }
        String[] searchableIndexes = this.getSearchableIndexes(skipContentPermForIndexes, repoNames);
        if (searchableIndexes.length == 0) {
            return Collections.emptyList();
        }
        return () -> new SearchHitIterator(query, searchableIndexes, skipContentPermForSearch);
    }

    @Override
    public SearchResponse searchUnrestrictedInRepos(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size, Collection<String> repoNames) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        String[] searchableIndexes = this.getSearchableIndexes(false, repoNames);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        return this.executeSearch(query, searchableIndexes, from, size, sort, null);
    }

    @Override
    public SearchResponse searchUnrestricted(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        String[] searchableIndexes = this.getSearchableIndexes(false);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        return this.executeSearch(query, searchableIndexes, from, size, sort, null);
    }

    @Override
    public SearchResponse search(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        String[] searchableIndexes = this.getSearchableIndexes(true);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (SearchSubjectHelper.SubjectRegistration registration = this.searchSubjectHelper.register(this.securityHelper.subject());){
            return this.executeSearch(query, searchableIndexes, from, size, sort, (QueryBuilder)QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SearchResponse searchInReposWithAggregations(QueryBuilder query, List<AggregationBuilder> aggregations, Collection<String> repoNames) {
        if (!this.validateQuery(query)) {
            return EMPTY_SEARCH_RESPONSE;
        }
        String[] searchableIndexes = this.getSearchableIndexes(true, repoNames);
        if (searchableIndexes.length == 0) {
            return EMPTY_SEARCH_RESPONSE;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (SearchSubjectHelper.SubjectRegistration registration = this.searchSubjectHelper.register(this.securityHelper.subject());){
            return this.executeSearch(query, aggregations, searchableIndexes, (QueryBuilder)QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private SearchResponse executeSearch(QueryBuilder query, String[] searchableIndexes, int from, int size, @Nullable List<SortBuilder> sort, @Nullable QueryBuilder postFilter) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)searchableIndexes);
        SearchRequestBuilder searchRequestBuilder = ((Client)this.client.get()).prepareSearch(searchableIndexes).setTypes(new String[]{TYPE}).setQuery(query).setFrom(from).setSize(size).setProfile(this.profile);
        if (postFilter != null) {
            searchRequestBuilder.setPostFilter(postFilter);
        }
        if (sort != null) {
            for (SortBuilder entry : sort) {
                searchRequestBuilder.addSort(entry);
            }
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (this.profile) {
            this.logProfileResults(searchResponse);
        }
        return searchResponse;
    }

    private SearchResponse executeSearch(QueryBuilder query, List<AggregationBuilder> aggregations, String[] searchableIndexes, @Nullable QueryBuilder postFilter) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull(aggregations);
        Preconditions.checkNotNull((Object)searchableIndexes);
        SearchRequestBuilder searchRequestBuilder = ((Client)this.client.get()).prepareSearch(searchableIndexes).setTypes(new String[]{TYPE}).setQuery(query).setFrom(0).setSize(0).setProfile(this.profile).setTrackScores(true);
        for (AggregationBuilder aggregation : aggregations) {
            searchRequestBuilder.addAggregation((AbstractAggregationBuilder)aggregation);
        }
        if (postFilter != null) {
            searchRequestBuilder.setPostFilter(postFilter);
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        if (this.profile) {
            this.logProfileResults(searchResponse);
        }
        return searchResponse;
    }

    @Override
    public long countUnrestricted(QueryBuilder query) {
        if (!this.validateQuery(query)) {
            return 0L;
        }
        String[] searchableIndexes = this.getSearchableIndexes(false);
        if (searchableIndexes.length == 0) {
            return 0L;
        }
        SearchRequestBuilder count = ((Client)this.client.get()).prepareSearch(searchableIndexes).setQuery(query).setSize(0);
        SearchResponse response = (SearchResponse)count.execute().actionGet();
        return response.getHits().totalHits();
    }

    private boolean validateQuery(QueryBuilder query) {
        Preconditions.checkNotNull((Object)query);
        try {
            ValidateQueryResponse validateQueryResponse = (ValidateQueryResponse)this.indicesAdminClient().prepareValidateQuery(new String[0]).setQuery(query).setExplain(true).execute().actionGet();
            if (!validateQueryResponse.isValid()) {
                if (this.log.isDebugEnabled()) {
                    Collection explanations = Collections2.transform((Collection)validateQueryResponse.getQueryExplanation(), (Function)new Function<QueryExplanation, String>(){

                        @Nullable
                        public String apply(QueryExplanation input) {
                            return input.getExplanation() != null ? input.getExplanation() : input.getError();
                        }
                    });
                    this.log.debug("Invalid query explanation: {}", (Object)explanations);
                }
                throw new IllegalArgumentException("Invalid query");
            }
        }
        catch (IndexNotFoundException indexNotFoundException) {
            return false;
        }
        return true;
    }

    private String[] getSearchableIndexes(boolean skipPermissionCheck) {
        return this.getSearchableIndexes(skipPermissionCheck, null);
    }

    @VisibleForTesting
    String[] getSearchableIndexes(boolean skipPermissionCheck, Collection<String> repoChoices) {
        Predicate<String> repoChoicesFilter = repoChoices == null ? s -> true : repoChoices::contains;
        return (String[])StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).map(repo -> {
            if (SearchServiceImpl.repoOnlineAndHasSearchFacet(repo) && this.repositoryNameMapping.containsKey(repo.getName()) && (skipPermissionCheck || this.securityHelper.allPermitted(new Permission[]{new RepositoryViewPermission((Repository)repo, "browse")}))) {
                return repo.getName();
            }
            return null;
        }).filter(Objects::nonNull).filter(repoChoicesFilter).map(this.repositoryNameMapping::get).toArray(String[]::new);
    }

    private static boolean repoOnlineAndHasSearchFacet(Repository repo) {
        return repo.optionalFacet(SearchFacet.class).isPresent() && repo.getConfiguration().isOnline();
    }

    private IndicesAdminClient indicesAdminClient() {
        return ((Client)this.client.get()).admin().indices();
    }

    private void logProfileResults(SearchResponse searchResponse) {
        for (Map.Entry entry : searchResponse.getProfileResults().entrySet()) {
            for (ProfileShardResult profileShardResult : (List)entry.getValue()) {
                try {
                    XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                    builder.startObject();
                    profileShardResult.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    builder.endObject();
                    this.log.info("Elasticsearch profile for {} is: {}", entry.getKey(), (Object)builder.string());
                }
                catch (IOException e) {
                    this.log.error("Error writing elasticsearch profile result", (Throwable)e);
                }
            }
        }
    }

    private class SearchHitIterator
    implements Iterator<SearchHit> {
        private final QueryBuilder query;
        private final String[] searchableIndexes;
        private final boolean skipPermissionCheck;
        private SearchResponse response;
        private Iterator<SearchHit> iterator;
        private boolean noMoreHits = false;

        private SearchHitIterator(QueryBuilder query, String[] searchableIndexes, boolean skipPermissionCheck) {
            this.query = query;
            this.searchableIndexes = searchableIndexes;
            this.skipPermissionCheck = skipPermissionCheck;
        }

        @Override
        public boolean hasNext() {
            if (this.noMoreHits) {
                return false;
            }
            if (this.response == null) {
                block14: {
                    SearchRequestBuilder builder = ((Client)SearchServiceImpl.this.client.get()).prepareSearch(this.searchableIndexes).setTypes(new String[]{SearchServiceImpl.TYPE}).setQuery(this.query).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).setSize(100).setProfile(SearchServiceImpl.this.profile);
                    if (!this.skipPermissionCheck) {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (SearchSubjectHelper.SubjectRegistration registration = SearchServiceImpl.this.searchSubjectHelper.register(SearchServiceImpl.this.securityHelper.subject());){
                            ScriptQueryBuilder permissionsFilter = QueryBuilders.scriptQuery((Script)ContentAuthPluginScriptFactory.newScript(registration.getId()));
                            builder.setPostFilter((QueryBuilder)permissionsFilter);
                            this.response = (SearchResponse)builder.execute().actionGet();
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    this.response = (SearchResponse)builder.execute().actionGet();
                }
                this.iterator = Arrays.asList(this.response.getHits().getHits()).iterator();
                this.noMoreHits = !this.iterator.hasNext();
            } else if (!this.iterator.hasNext()) {
                SearchScrollRequestBuilder builder = ((Client)SearchServiceImpl.this.client.get()).prepareSearchScroll(this.response.getScrollId()).setScroll(new TimeValue(1L, TimeUnit.MINUTES));
                this.response = (SearchResponse)builder.execute().actionGet();
                this.iterator = Arrays.asList(this.response.getHits().getHits()).iterator();
                this.noMoreHits = !this.iterator.hasNext();
            }
            return this.iterator.hasNext();
        }

        @Override
        public SearchHit next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

