/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.security.authz.WildcardPermission2;
import org.sonatype.nexus.selector.SelectorConfiguration;

public class RepositoryContentSelectorPermission
extends WildcardPermission2 {
    public static final String SYSTEM = "nexus";
    public static final String DOMAIN = "repository-content-selector";
    private final String selector;
    private final String format;
    private final String name;
    private final List<String> actions;

    public RepositoryContentSelectorPermission(String selector, String format, String name, List<String> actions) {
        this.selector = (String)Preconditions.checkNotNull((Object)selector);
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.actions = (List)Preconditions.checkNotNull(actions);
        this.setParts((List)ImmutableList.of((Object)SYSTEM, (Object)DOMAIN, (Object)selector, (Object)format, (Object)name), actions);
    }

    public RepositoryContentSelectorPermission(SelectorConfiguration selector, Repository repository, List<String> actions) {
        this(selector.getName(), repository.getFormat().getValue(), repository.getName(), actions);
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getActions() {
        return this.actions;
    }
}

