/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.SelectorComboFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.security.RepositoryContentSelectorPermission;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;

@Named(value="repository-content-selector")
@Singleton
public class RepositoryContentSelectorPrivilegeDescriptor
extends PrivilegeDescriptorSupport {
    public static final String TYPE = "repository-content-selector";
    public static final String P_CONTENT_SELECTOR = "contentSelector";
    public static final String P_REPOSITORY = "repository";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new SelectorComboFormField("contentSelector", messages.contentSelector(), messages.contentSelectorHelp(), true), (Object)new RepositoryCombobox("repository", messages.repository(), messages.repositoryHelp(), true).includeEntriesForAllFormats(), (Object)new StringTextFormField("actions", messages.actions(), messages.actionsHelp(), true));

    public RepositoryContentSelectorPrivilegeDescriptor() {
        super(TYPE);
    }

    public Permission createPermission(CPrivilege privilege) {
        assert (privilege != null);
        String contentSelector = this.readProperty(privilege, P_CONTENT_SELECTOR, "*");
        String name = this.readProperty(privilege, P_REPOSITORY, "*");
        List actions = this.readListProperty(privilege, P_ACTIONS, "*");
        RepositorySelector selector = RepositorySelector.fromSelector(name);
        return new RepositoryContentSelectorPermission(contentSelector, selector.getFormat(), selector.getName(), actions);
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static String id(String contentSelector, String format, String name, String ... actions) {
        return String.format("nx-%s-%s-%s-%s-%s", TYPE, contentSelector, format, name, Joiner.on((char)',').join((Object[])actions));
    }

    public static CPrivilege privilege(String contentSelector, String format, String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        RepositorySelector selector = RepositorySelector.fromNameAndFormat(name, format);
        return new CPrivilegeBuilder().type(TYPE).id(RepositoryContentSelectorPrivilegeDescriptor.id(contentSelector, format, name, actions)).description(String.format("%s for %s repository content selector %s", RepositoryContentSelectorPrivilegeDescriptor.humanizeActions((String[])actions), selector.humanizeSelector(), contentSelector)).property(P_CONTENT_SELECTOR, contentSelector).property(P_REPOSITORY, selector.toSelector()).property(P_ACTIONS, actions).create();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository Content Selector")
        public String name();

        @MessageBundle.DefaultMessage(value="Content Selector")
        public String contentSelector();

        @MessageBundle.DefaultMessage(value="The content selector for the repository")
        public String contentSelectorHelp();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repository();

        @MessageBundle.DefaultMessage(value="The repository or repositories to grant access")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="The comma-delimited list of actions")
        public String actionsHelp();
    }
}

