/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.RepositoryContentSelectorPermission;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class RepositoryPermissionChecker {
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;

    @Inject
    public RepositoryPermissionChecker(SecurityHelper securityHelper, SelectorManager selectorManager) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    public boolean userCanBrowseRepository(Repository repository) {
        return this.userHasRepositoryViewPermissionTo("browse", repository) || this.userHasAnyContentSelectorAccessTo(repository, "browse");
    }

    public boolean userCanDeleteInRepository(Repository repository) {
        return this.userHasRepositoryViewPermissionTo("delete", repository) || this.userHasAnyContentSelectorAccessTo(repository, "delete");
    }

    private boolean userHasRepositoryViewPermissionTo(String action, Repository repository) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(repository, action)});
    }

    public List<Repository> userCanBrowseRepositories(Repository ... repositories) {
        if (repositories.length == 0) {
            return Collections.emptyList();
        }
        Subject subject = this.securityHelper.subject();
        Permission[] permissions = (Permission[])Arrays.stream(repositories).map(r -> new RepositoryViewPermission((Repository)r, "browse")).toArray(Permission[]::new);
        boolean[] results = this.securityHelper.isPermitted(subject, permissions);
        ArrayList<Repository> permittedRepositories = new ArrayList<Repository>();
        ArrayList<Repository> filteredRepositories = new ArrayList<Repository>();
        int i = 0;
        while (i < results.length) {
            if (results[i]) {
                permittedRepositories.add(repositories[i]);
            } else {
                filteredRepositories.add(repositories[i]);
            }
            ++i;
        }
        if (!filteredRepositories.isEmpty()) {
            permittedRepositories.addAll(this.subjectHasAnyContentSelectorAccessTo(subject, filteredRepositories));
        }
        return permittedRepositories;
    }

    private List<Repository> subjectHasAnyContentSelectorAccessTo(Subject subject, List<Repository> repositories) {
        List formats;
        List repositoryNames = repositories.stream().map(r -> r.getName()).collect(Collectors.toList());
        List selectors = this.selectorManager.browseActive(repositoryNames, formats = repositories.stream().map(r -> r.getFormat().getValue()).distinct().collect(Collectors.toList()));
        if (selectors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Repository> permittedRepositories = new ArrayList<Repository>();
        for (Repository repository : repositories) {
            Permission[] permissions = (Permission[])selectors.stream().map(s -> new RepositoryContentSelectorPermission((SelectorConfiguration)s, repository, Collections.singletonList("browse"))).toArray(Permission[]::new);
            if (!this.securityHelper.anyPermitted(subject, permissions)) continue;
            permittedRepositories.add(repository);
        }
        return permittedRepositories;
    }

    private boolean userHasAnyContentSelectorAccessTo(Repository repository, String action) {
        Subject subject = this.securityHelper.subject();
        return this.selectorManager.browse().stream().anyMatch(selector -> this.securityHelper.anyPermitted(subject, new Permission[]{new RepositoryContentSelectorPermission((SelectorConfiguration)selector, repository, Collections.singletonList(action))}));
    }
}

