/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public class RepositorySelector {
    @VisibleForTesting
    public static final String ALL = "*";
    private static final String ALL_OF_FORMAT_PREFIX = "*-";
    private final String name;
    private final String format;

    private RepositorySelector(String name, String format) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.format = (String)Preconditions.checkNotNull((Object)format);
    }

    public static RepositorySelector all() {
        return new RepositorySelector(ALL, ALL);
    }

    public static RepositorySelector allOfFormat(String format) {
        return new RepositorySelector(ALL, format);
    }

    public static RepositorySelector fromSelector(String selector) {
        Preconditions.checkNotNull((Object)selector);
        if (ALL.equals(selector)) {
            return new RepositorySelector(ALL, ALL);
        }
        if (selector.startsWith(ALL_OF_FORMAT_PREFIX)) {
            return new RepositorySelector(ALL, selector.substring(ALL_OF_FORMAT_PREFIX.length()));
        }
        return new RepositorySelector(selector, ALL);
    }

    public static RepositorySelector fromNameAndFormat(String name, String format) {
        return new RepositorySelector(name, format);
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String toSelector() {
        if (ALL.equals(this.name)) {
            if (ALL.equals(this.format)) {
                return ALL;
            }
            return ALL_OF_FORMAT_PREFIX + this.format;
        }
        return this.name;
    }

    public String humanizeSelector() {
        if (ALL.equals(this.name)) {
            if (ALL.equals(this.format)) {
                return "all";
            }
            return "all '" + this.format + "'-format";
        }
        return this.name;
    }

    public boolean isAllRepositories() {
        return ALL.equals(this.name);
    }

    public boolean isAllFormats() {
        return ALL.equals(this.format);
    }
}

