/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;

@Named(value="repository-view")
@Singleton
public class RepositoryViewPrivilegeDescriptor
extends PrivilegeDescriptorSupport {
    public static final String TYPE = "repository-view";
    public static final String P_FORMAT = "format";
    public static final String P_REPOSITORY = "repository";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new StringTextFormField("format", messages.format(), messages.formatHelp(), true), (Object)new RepositoryCombobox("repository", messages.repository(), messages.repositoryHelp(), true).includeAnEntryForAllRepositories(), (Object)new StringTextFormField("actions", messages.actions(), messages.actionsHelp(), true));

    public RepositoryViewPrivilegeDescriptor() {
        super(TYPE);
    }

    public Permission createPermission(CPrivilege privilege) {
        assert (privilege != null);
        String format = this.readProperty(privilege, P_FORMAT, "*");
        String name = this.readProperty(privilege, P_REPOSITORY, "*");
        List actions = this.readListProperty(privilege, P_ACTIONS, "*");
        return new RepositoryViewPermission(format, name, actions);
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static String id(String format, String name, String ... actions) {
        return String.format("nx-%s-%s-%s-%s", TYPE, format, name, Joiner.on((char)',').join((Object[])actions));
    }

    public static CPrivilege privilege(String format, String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        return new CPrivilegeBuilder().type(TYPE).id(RepositoryViewPrivilegeDescriptor.id(format, name, actions)).description(String.format("%s for %s repository views", RepositoryViewPrivilegeDescriptor.humanizeActions((String[])actions), RepositoryViewPrivilegeDescriptor.humanizeName((String)name, (String)format))).property(P_FORMAT, format).property(P_REPOSITORY, name).property(P_ACTIONS, actions).create();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repository View")
        public String name();

        @MessageBundle.DefaultMessage(value="Format")
        public String format();

        @MessageBundle.DefaultMessage(value="The format(s) for the repository")
        public String formatHelp();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repository();

        @MessageBundle.DefaultMessage(value="The repository name")
        public String repositoryHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="The comma-delimited list of actions")
        public String actionsHelp();
    }
}

