/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class SecurityHandler
extends ComponentSupport
implements Handler {
    @VisibleForTesting
    static final String AUTHORIZED_KEY = "security.authorized";

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        SecurityFacet securityFacet = context.getRepository().facet(SecurityFacet.class);
        if (context.getAttributes().get(AUTHORIZED_KEY) == null) {
            securityFacet.ensurePermitted(context.getRequest());
            context.getAttributes().set(AUTHORIZED_KEY, (Object)true);
        }
        return context.proceed();
    }
}

