/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.security;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.ConstantVariableResolver;
import org.sonatype.nexus.selector.PropertiesResolver;
import org.sonatype.nexus.selector.VariableResolver;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.selector.VariableSourceBuilder;

public abstract class VariableResolverAdapterSupport
implements VariableResolverAdapter {
    protected static final String PATH = "path";
    protected static final String FORMAT = "format";

    @Override
    public VariableSource fromRequest(Request request, Repository repository) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)request.getPath(), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)repository.getFormat().getValue(), new String[]{FORMAT}));
        this.addFromRequest(builder, request);
        return builder.build();
    }

    protected abstract void addFromRequest(VariableSourceBuilder var1, Request var2);

    @Override
    public VariableSource fromDocument(ODocument document) {
        String path = (String)document.field("name", String.class);
        String format = (String)document.field(FORMAT, String.class);
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)(String.valueOf('/') + path), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)format, new String[]{FORMAT}));
        this.addFromDocument(builder, document);
        return builder.build();
    }

    protected abstract void addFromDocument(VariableSourceBuilder var1, ODocument var2);

    @Override
    public VariableSource fromAsset(Asset asset) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)(String.valueOf('/') + asset.name()), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)asset.format(), new String[]{FORMAT}));
        this.addFromAsset(builder, asset);
        return builder.build();
    }

    protected abstract void addFromAsset(VariableSourceBuilder var1, Asset var2);

    @Override
    public VariableSource fromCoordinates(String format, String path, Map<String, String> coordinates) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)(String.valueOf('/') + (String)Preconditions.checkNotNull((Object)path)), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)format), new String[]{FORMAT}));
        this.addCoordinates(builder, coordinates);
        return builder.build();
    }

    @Override
    public VariableSource fromSourceLookup(SourceLookup sourceLookup, Map<String, Object> asset) {
        VariableSourceBuilder builder = new VariableSourceBuilder();
        builder.addResolver((VariableResolver)new ConstantVariableResolver((Object)(String.valueOf('/') + (String)Preconditions.checkNotNull((Object)((String)asset.get("name")))), new String[]{PATH}));
        builder.addResolver((VariableResolver)new ConstantVariableResolver(Preconditions.checkNotNull((Object)sourceLookup.get((Object)FORMAT)), new String[]{FORMAT}));
        this.addFromSourceLookup(builder, sourceLookup, asset);
        return builder.build();
    }

    protected abstract void addFromSourceLookup(VariableSourceBuilder var1, SourceLookup var2, Map<String, Object> var3);

    protected void addCoordinates(VariableSourceBuilder builder, Map<String, String> coordinates) {
        builder.addResolver((VariableResolver)new PropertiesResolver("coordinate", coordinates));
    }
}

