/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.selector.internal.ContentAuthHelper;

@Named
@Singleton
public class ContentAuth
extends OSQLFunctionAbstract {
    public static final String NAME = "contentAuth";
    private final ContentAuthHelper contentAuthHelper;

    @Inject
    public ContentAuth(ContentAuthHelper contentAuthHelper) {
        super(NAME, 2, 3);
        this.contentAuthHelper = (ContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OIdentifiable identifiable = (OIdentifiable)iParams[0];
        ODocument document = (ODocument)identifiable.getRecord();
        String browsedRepositoryName = (String)iParams[1];
        boolean jexlOnly = iParams.length > 2 && (Boolean)iParams[2] != false;
        switch (document.getClassName()) {
            case "asset": {
                return this.checkAssetPermissions(document, browsedRepositoryName, jexlOnly);
            }
            case "component": {
                return this.checkComponentAssetPermissions(document, browsedRepositoryName, jexlOnly);
            }
        }
        return false;
    }

    private boolean checkComponentAssetPermissions(ODocument component, String sourceRepositoryName, boolean jexlOnly) {
        Preconditions.checkNotNull((Object)component);
        for (ODocument asset : this.browseComponentAssets(component)) {
            if (!this.checkAssetPermissions(asset, sourceRepositoryName, jexlOnly)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAssetPermissions(ODocument asset, String repositoryName, boolean jexlOnly) {
        if (jexlOnly) {
            return this.contentAuthHelper.checkAssetPermissionsJexlOnly(asset, repositoryName);
        }
        return this.contentAuthHelper.checkAssetPermissions(asset, repositoryName);
    }

    public String getSyntax() {
        return "contentAuth(<asset|component>, [jexlSelectorsOnly])";
    }

    private Iterable<ODocument> browseComponentAssets(ODocument component) {
        Preconditions.checkNotNull((Object)component);
        OIdentifiable bucket = (OIdentifiable)component.field("bucket", OIdentifiable.class);
        ODatabaseDocumentInternal db = component.getDatabase();
        Iterable results = (Iterable)db.command((OCommandRequest)new OCommandSQL("select from asset where bucket = :bucket and component = :component")).execute(new Object[]{new ImmutableMap.Builder().put((Object)"bucket", (Object)bucket.getIdentity()).put((Object)"component", (Object)component.getIdentity()).build()});
        return results;
    }
}

