/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.DatabaseThreadUtils;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class ContentAuthHelper {
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final ContentPermissionChecker contentPermissionChecker;

    @Inject
    public ContentAuthHelper(VariableResolverAdapterManager variableResolverAdapterManager, ContentPermissionChecker contentPermissionChecker) {
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
    }

    public boolean checkAssetPermissions(ODocument asset, String ... repositoryNames) {
        String format = (String)asset.field("format", String.class);
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        VariableSource variableSource = variableResolverAdapter.fromDocument(asset);
        return DatabaseThreadUtils.withOtherDatabase(() -> {
            String[] stringArray2 = repositoryNames;
            int n = repositoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String repositoryName = stringArray2[n2];
                if (this.contentPermissionChecker.isPermitted(repositoryName, format, "browse", variableSource)) {
                    return true;
                }
                ++n2;
            }
            return false;
        });
    }

    public boolean checkAssetPermissionsJexlOnly(ODocument asset, String ... repositoryNames) {
        String format = (String)asset.field("format", String.class);
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        VariableSource variableSource = variableResolverAdapter.fromDocument(asset);
        return DatabaseThreadUtils.withOtherDatabase(() -> Arrays.stream(repositoryNames).anyMatch(repositoryName -> this.contentPermissionChecker.isPermittedJexlOnly((String)repositoryName, format, "browse", variableSource)));
    }
}

