/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptModule;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.SearchSubjectHelper;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.selector.internal.ContentAuthPluginScriptFactory;

public class ContentAuthPlugin
extends Plugin {
    private static ContentPermissionChecker contentPermissionChecker;
    private static VariableResolverAdapterManager variableResolverAdapterManager;
    private static SearchSubjectHelper searchSubjectHelper;
    private static RepositoryManager repositoryManager;

    public ContentAuthPlugin() {
        Preconditions.checkNotNull((Object)contentPermissionChecker);
        Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        Preconditions.checkNotNull((Object)((Object)searchSubjectHelper));
        Preconditions.checkNotNull((Object)repositoryManager);
    }

    public String name() {
        return "content-auth-plugin";
    }

    public String description() {
        return "ES plugin for working with content selectors";
    }

    public void onModule(ScriptModule module) {
        module.registerScript("content_auth", ContentAuthPluginScriptFactory.class);
    }

    public static void setDependencies(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, SearchSubjectHelper searchSubjectHelper, RepositoryManager repositoryManager) {
        ContentAuthPlugin.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        ContentAuthPlugin.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        ContentAuthPlugin.searchSubjectHelper = (SearchSubjectHelper)((Object)Preconditions.checkNotNull((Object)((Object)searchSubjectHelper)));
        ContentAuthPlugin.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public static ContentPermissionChecker getContentPermissionChecker() {
        return contentPermissionChecker;
    }

    public static VariableResolverAdapterManager getVariableResolverAdapterManager() {
        return variableResolverAdapterManager;
    }

    public static SearchSubjectHelper getSearchSubjectHelper() {
        return searchSubjectHelper;
    }

    public static RepositoryManager getRepositoryManager() {
        return repositoryManager;
    }
}

