/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.elasticsearch.script.AbstractSearchScript;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.selector.VariableSource;

public class ContentAuthPluginScript
extends AbstractSearchScript {
    public static final String NAME = "content_auth";
    private final Subject subject;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final ContentPermissionChecker contentPermissionChecker;
    private final RepositoryManager repositoryManager;

    public ContentAuthPluginScript(Subject subject, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager) {
        this.subject = (Subject)Preconditions.checkNotNull((Object)subject);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public Object run() {
        SubjectThreadState threadState = new SubjectThreadState(this.subject);
        threadState.bind();
        try {
            Iterator iterator;
            SourceLookup sourceLookup = this.getSourceLookup();
            String format = (String)Preconditions.checkNotNull((Object)sourceLookup.get((Object)"format"));
            String repositoryName = (String)Preconditions.checkNotNull((Object)sourceLookup.get((Object)"repository_name"));
            VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
            List assets = (List)sourceLookup.getOrDefault((Object)"assets", Collections.emptyList());
            if (assets != null && (iterator = assets.iterator()).hasNext()) {
                Map asset = (Map)iterator.next();
                VariableSource variableSource = variableResolverAdapter.fromSourceLookup(sourceLookup, asset);
                HashSet<String> repoNames = new HashSet<String>();
                repoNames.add(repositoryName);
                repoNames.addAll(this.repositoryManager.findContainingGroups(repositoryName));
                Boolean bl = this.contentPermissionChecker.isPermitted(repoNames, format, "browse", variableSource);
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            threadState.clear();
        }
    }

    @VisibleForTesting
    protected SourceLookup getSourceLookup() {
        return this.source();
    }
}

