/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.selector.internal.ContentAuthHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class ContentExpressionFunction
extends OSQLFunctionAbstract {
    public static final String NAME = "contentExpression";
    private static final Logger log = LoggerFactory.getLogger(ContentExpressionFunction.class);
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final SelectorManager selectorManager;
    private final ContentAuthHelper contentAuthHelper;

    @Inject
    public ContentExpressionFunction(VariableResolverAdapterManager variableResolverAdapterManager, SelectorManager selectorManager, ContentAuthHelper contentAuthHelper) {
        super(NAME, 4, 4);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.contentAuthHelper = (ContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        List membersForAuth;
        OIdentifiable identifiable = (OIdentifiable)iParams[0];
        ODocument asset = (ODocument)identifiable.getRecord();
        RepositorySelector repositorySelector = RepositorySelector.fromSelector((String)iParams[2]);
        String jexlExpression = (String)iParams[1];
        if (!repositorySelector.isAllRepositories()) {
            membersForAuth = Arrays.asList(repositorySelector.getName());
        } else {
            Map repoToContainedGroupMap = (Map)iParams[3];
            String assetRepository = this.getAssetRepository(asset);
            if (assetRepository == null) {
                log.error("Asset {} references no repository", (Object)this.getAssetName(asset));
                return false;
            }
            membersForAuth = (List)repoToContainedGroupMap.get(assetRepository);
            if (membersForAuth == null) {
                log.error("Asset {} references an invalid repository: {}", (Object)this.getAssetName(asset), (Object)assetRepository);
                return false;
            }
        }
        if (this.contentAuthHelper.checkAssetPermissions(asset, membersForAuth.toArray(new String[membersForAuth.size()])) && this.checkJexlExpression(asset, jexlExpression, (String)asset.field("format", String.class))) {
            return true;
        }
        return false;
    }

    @Nullable
    private String getAssetRepository(ODocument asset) {
        OIdentifiable bucketId = (OIdentifiable)asset.field("bucket", OIdentifiable.class);
        ODocument bucket = (ODocument)bucketId.getRecord();
        return (String)bucket.field("repository_name", String.class);
    }

    private String getAssetName(ODocument asset) {
        return (String)asset.field("name", String.class);
    }

    private boolean checkJexlExpression(ODocument asset, String jexlExpression, String format) {
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        VariableSource variableSource = variableResolverAdapter.fromDocument(asset);
        SelectorConfiguration selectorConfiguration = new SelectorConfiguration();
        selectorConfiguration.setAttributes((Map)ImmutableMap.of((Object)"expression", (Object)jexlExpression));
        selectorConfiguration.setType("jexl");
        selectorConfiguration.setName("preview");
        try {
            return this.selectorManager.evaluate(selectorConfiguration, variableSource);
        }
        catch (SelectorEvaluationException e) {
            log.debug("Unable to evaluate expression {}.", (Object)jexlExpression, (Object)e);
            return false;
        }
    }

    public String getSyntax() {
        return "contentExpression(<asset>, <string>, <string>, <string>)";
    }
}

