/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.MetadataNode;

public abstract class AbstractMetadataNode<T>
extends AbstractEntity
implements MetadataNode<T> {
    private boolean newEntity = true;
    private EntityId bucketId;
    private String name;
    private DateTime lastUpdated;
    private String format;
    private NestedAttributesMap attributes;

    @Override
    public boolean isNew() {
        return this.newEntity;
    }

    @Override
    public T newEntity(boolean newEntity) {
        this.newEntity = newEntity;
        return this.self();
    }

    @Override
    public EntityId bucketId() {
        return this.require(this.bucketId, "bucket");
    }

    @Override
    public T bucketId(EntityId bucketId) {
        this.bucketId = (EntityId)Preconditions.checkNotNull((Object)bucketId);
        return this.self();
    }

    @Override
    public String name() {
        return this.require(this.name, "name");
    }

    @Override
    public T name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        return this.self();
    }

    @Override
    @Nullable
    public DateTime lastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public DateTime requireLastUpdated() {
        return this.require(this.lastUpdated, "last_updated");
    }

    @Override
    public T lastUpdated(DateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this.self();
    }

    @Override
    public String format() {
        return this.require(this.format, "format");
    }

    @Override
    public T format(String format) {
        this.format = format;
        return this.self();
    }

    @Override
    public NestedAttributesMap attributes() {
        return this.require(this.attributes, "attributes");
    }

    @Override
    public T attributes(NestedAttributesMap attributes) {
        this.attributes = attributes;
        return this.self();
    }

    @Override
    public NestedAttributesMap formatAttributes() {
        return this.attributes().child(this.format());
    }

    protected <V> V require(V value, String name) {
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"Missing property: %s", (Object)name);
        return value;
    }

    private T self() {
        return (T)this;
    }
}

