/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;

public class Asset
extends AbstractMetadataNode<Asset> {
    public static final String CHECKSUM = "checksum";
    public static final String PROVENANCE = "provenance";
    public static final String HASHES_NOT_VERIFIED = "hashes_not_verified";
    private EntityId componentId;
    private Long size;
    private String contentType;
    private BlobRef blobRef;
    private DateTime lastDownloaded;
    private DateTime blobCreated;
    private DateTime blobUpdated;
    private String createdBy;
    private String createdByIp;

    @Nullable
    public EntityId componentId() {
        return this.componentId;
    }

    public Asset componentId(EntityId componentId) {
        this.componentId = componentId;
        return this;
    }

    @Nullable
    public Long size() {
        return this.size;
    }

    public Long requireSize() {
        return this.require(this.size, "size");
    }

    public Asset size(@Nullable Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    public String createdBy() {
        return this.createdBy;
    }

    @Nullable
    public String createdByIp() {
        return this.createdByIp;
    }

    public Asset createdBy(@Nullable String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Asset createdByIp(@Nullable String createdByIp) {
        this.createdByIp = createdByIp;
        return this;
    }

    @Nullable
    public String contentType() {
        return this.contentType;
    }

    public String requireContentType() {
        return this.require(this.contentType, "content_type");
    }

    public Asset contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    public BlobRef blobRef() {
        return this.blobRef;
    }

    public BlobRef requireBlobRef() {
        return this.require(this.blobRef, "blob_ref");
    }

    public Asset blobRef(@Nullable BlobRef blobRef) {
        this.blobRef = blobRef;
        return this;
    }

    @Nullable
    public DateTime lastDownloaded() {
        return this.lastDownloaded;
    }

    @VisibleForTesting
    public Asset lastDownloaded(DateTime lastDownloaded) {
        this.lastDownloaded = lastDownloaded;
        return this;
    }

    public boolean markAsDownloaded() {
        DateTime now = DateTime.now();
        if (this.lastDownloaded == null || this.lastDownloaded.isBefore((ReadableInstant)now.minusHours(12))) {
            this.lastDownloaded(now);
            return true;
        }
        return false;
    }

    public Map<HashAlgorithm, HashCode> getChecksums(Iterable<HashAlgorithm> hashAlgorithms) {
        NestedAttributesMap checksumAttributes = this.attributes().child(CHECKSUM);
        HashMap hashCodes = Maps.newHashMap();
        for (HashAlgorithm algorithm : hashAlgorithms) {
            HashCode hashCode = HashCode.fromString((String)((String)checksumAttributes.require(algorithm.name(), String.class)));
            hashCodes.put(algorithm, hashCode);
        }
        return hashCodes;
    }

    @Nullable
    public HashCode getChecksum(HashAlgorithm hashAlgorithm) {
        String hashCode = (String)this.attributes().child(CHECKSUM).get(hashAlgorithm.name(), String.class);
        if (hashCode != null) {
            return HashCode.fromString((String)hashCode);
        }
        return null;
    }

    @Nullable
    public DateTime blobCreated() {
        return this.blobCreated;
    }

    public Asset blobCreated(@Nullable DateTime blobCreated) {
        this.blobCreated = blobCreated;
        return this;
    }

    @Nullable
    public DateTime blobUpdated() {
        return this.blobUpdated;
    }

    public Asset blobUpdated(@Nullable DateTime blobUpdated) {
        this.blobUpdated = blobUpdated;
        return this;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "metadata=" + this.getEntityMetadata() + ", name=" + this.name() + '}';
    }
}

