/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.MetadataNodeEntityAdapter;

@Named
@Singleton
public class AssetEntityAdapter
extends MetadataNodeEntityAdapter<Asset> {
    private static final String DB_CLASS = new OClassNameBuilder().type("asset").build();
    public static final String P_ASSET_KIND = "asset_kind";
    public static final String P_BLOB_REF = "blob_ref";
    public static final String P_COMPONENT = "component";
    public static final String P_CONTENT_TYPE = "content_type";
    public static final String P_LAST_DOWNLOADED = "last_downloaded";
    public static final String P_SIZE = "size";
    public static final String P_CREATED_BY = "created_by";
    public static final String P_CREATED_BY_IP = "created_by_ip";
    public static final String P_BLOB_CREATED = "blob_created";
    public static final String P_BLOB_UPDATED = "blob_updated";
    public static final String I_BUCKET_COMPONENT_NAME = new OIndexNameBuilder().type(DB_CLASS).property("bucket").property("component").property("name").build();
    private static final String I_BUCKET_NAME = new OIndexNameBuilder().type(DB_CLASS).property("bucket").property("name").build();
    public static final String I_COMPONENT = new OIndexNameBuilder().type(DB_CLASS).property("component").build();
    public static final String I_NAME_CASEINSENSITIVE = new OIndexNameBuilder().type(DB_CLASS).property("name").caseInsensitive().build();
    private static final String EXISTS_QUERY_STRING = String.format("select from index:%1$s where key = [:%2$s, :%3$s]", I_BUCKET_NAME, "bucket", "name");
    private static final OSQLSynchQuery<ODocument> EXISTS_QUERY = new OSQLSynchQuery(EXISTS_QUERY_STRING, 1);
    private final ComponentEntityAdapter componentEntityAdapter;

    @Inject
    public AssetEntityAdapter(BucketEntityAdapter bucketEntityAdapter, ComponentEntityAdapter componentEntityAdapter) {
        super(DB_CLASS, bucketEntityAdapter);
        this.componentEntityAdapter = componentEntityAdapter;
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(type);
        type.createProperty(P_COMPONENT, OType.LINK, this.componentEntityAdapter.getSchemaType());
        type.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_SIZE, OType.LONG);
        type.createProperty(P_CONTENT_TYPE, OType.STRING);
        type.createProperty(P_BLOB_REF, OType.STRING);
        type.createProperty(P_LAST_DOWNLOADED, OType.DATETIME);
        type.createProperty(P_BLOB_CREATED, OType.DATETIME);
        type.createProperty(P_BLOB_UPDATED, OType.DATETIME);
        type.createProperty(P_CREATED_BY, OType.STRING);
        type.createProperty(P_CREATED_BY_IP, OType.STRING);
        ODocument metadata = db.newInstance().field("ignoreNullValues", (Object)false).field("mergeKeys", (Object)false);
        type.createIndex(I_BUCKET_COMPONENT_NAME, OClass.INDEX_TYPE.UNIQUE.name(), null, metadata, new String[]{"bucket", P_COMPONENT, "name"});
        type.createIndex(I_BUCKET_NAME, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{"bucket", "name"});
        type.createIndex(I_COMPONENT, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_COMPONENT});
        new OIndexBuilder(type, I_NAME_CASEINSENSITIVE, OClass.INDEX_TYPE.NOTUNIQUE).property("name", OType.STRING).caseInsensitive().build(db);
    }

    protected Asset newEntity() {
        return new Asset();
    }

    @Override
    protected void readFields(ODocument document, Asset entity) {
        super.readFields(document, entity);
        ORID componentId = (ORID)document.field(P_COMPONENT, ORID.class);
        String name = (String)document.field("name", OType.STRING);
        Long size = (Long)document.field(P_SIZE, OType.LONG);
        String contentType = (String)document.field(P_CONTENT_TYPE, OType.STRING);
        String blobRef = (String)document.field(P_BLOB_REF, OType.STRING);
        Date lastDownloaded = (Date)document.field(P_LAST_DOWNLOADED, OType.DATETIME);
        Date blobCreated = (Date)document.field(P_BLOB_CREATED, OType.DATETIME);
        Date blobUpdated = (Date)document.field(P_BLOB_UPDATED, OType.DATETIME);
        String createdBy = (String)document.field(P_CREATED_BY, OType.STRING);
        String createdByIp = (String)document.field(P_CREATED_BY_IP, OType.STRING);
        if (componentId != null) {
            entity.componentId((EntityId)new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, componentId));
        }
        entity.name(name);
        entity.size(size);
        entity.contentType(contentType);
        entity.createdBy(createdBy);
        entity.createdByIp(createdByIp);
        if (blobRef != null) {
            entity.blobRef(BlobRef.parse((String)blobRef));
        }
        if (lastDownloaded != null) {
            entity.lastDownloaded(new DateTime((Object)lastDownloaded));
        }
        if (blobCreated != null) {
            entity.blobCreated(new DateTime((Object)blobCreated));
        }
        if (blobUpdated != null) {
            entity.blobUpdated(new DateTime((Object)blobUpdated));
        }
    }

    @Override
    protected void writeFields(ODocument document, Asset entity) {
        super.writeFields(document, entity);
        EntityId componentId = entity.componentId();
        document.field(P_COMPONENT, componentId != null ? this.componentEntityAdapter.recordIdentity(componentId) : null);
        document.field("name", (Object)entity.name());
        document.field(P_SIZE, (Object)entity.size());
        document.field(P_CONTENT_TYPE, (Object)entity.contentType());
        document.field(P_CREATED_BY, (Object)entity.createdBy());
        document.field(P_CREATED_BY_IP, (Object)entity.createdByIp());
        BlobRef blobRef = entity.blobRef();
        document.field(P_BLOB_REF, (Object)(blobRef != null ? blobRef.toString() : null));
        DateTime lastDownloaded = entity.lastDownloaded();
        document.field(P_LAST_DOWNLOADED, (Object)(lastDownloaded != null ? lastDownloaded.toDate() : null));
        DateTime blobCreated = entity.blobCreated();
        document.field(P_BLOB_CREATED, (Object)(blobCreated != null ? blobCreated.toDate() : null));
        DateTime blobUpdated = entity.blobUpdated();
        document.field(P_BLOB_UPDATED, (Object)(blobUpdated != null ? blobUpdated.toDate() : null));
    }

    Asset findByProperty(ODatabaseDocumentTx db, String propName, Object propValue, Component component) {
        Preconditions.checkNotNull((Object)propName);
        Preconditions.checkNotNull((Object)propValue);
        Preconditions.checkNotNull((Object)component);
        ImmutableMap parameters = ImmutableMap.of((Object)"bucket", (Object)this.bucketEntityAdapter.recordIdentity(component.bucketId()), (Object)P_COMPONENT, (Object)this.componentEntityAdapter.recordIdentity(component), (Object)"propValue", (Object)propValue);
        String query = String.format("select from %s where %s = :bucket and %s = :component and %s = :propValue", DB_CLASS, "bucket", P_COMPONENT, propName);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        ODocument first = (ODocument)Iterables.getFirst((Iterable)docs, null);
        return first != null ? (Asset)this.readEntity(first) : null;
    }

    Iterable<Asset> browseByComponent(ODatabaseDocumentTx db, Component component) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkState((boolean)EntityHelper.hasMetadata((Entity)component));
        ImmutableMap parameters = ImmutableMap.of((Object)"bucket", (Object)this.bucketEntityAdapter.recordIdentity(component.bucketId()), (Object)P_COMPONENT, (Object)this.componentEntityAdapter.recordIdentity(component));
        String query = String.format("select from %s where %s = :bucket and %s = :component", DB_CLASS, "bucket", P_COMPONENT);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        return this.transform(docs);
    }

    public Asset findByBucketComponentName(ODatabaseDocumentTx db, ORID bucketId, @Nullable ORID componentId, String name) {
        Iterable docs;
        ODocument first;
        String query = "select from " + DB_CLASS + " where " + "bucket" + " = :bucket ";
        query = String.valueOf(query) + "and component" + (componentId == null ? " is null " : " = :component ");
        query = String.valueOf(query) + "and name = :name";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("bucket", bucketId);
        parameters.put("name", name);
        if (componentId != null) {
            parameters.put(P_COMPONENT, componentId);
        }
        return (first = (ODocument)Iterables.getFirst((Iterable)(docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters})), null)) != null ? (Asset)this.readEntity(first) : null;
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String repositoryName = (String)((ODocument)document.field("bucket")).field("repository_name");
        ORID rid = (ORID)document.field(P_COMPONENT, ORID.class);
        AttachedEntityId componentId = rid != null ? new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, rid) : null;
        switch (eventKind) {
            case CREATE: {
                return new AssetCreatedEvent((EntityMetadata)metadata, repositoryName, (EntityId)componentId);
            }
            case UPDATE: {
                return new AssetUpdatedEvent((EntityMetadata)metadata, repositoryName, (EntityId)componentId);
            }
            case DELETE: {
                return new AssetDeletedEvent((EntityMetadata)metadata, repositoryName, (EntityId)componentId);
            }
        }
        return null;
    }

    public String eventAffinity(ODocument document) {
        ORID bucketId = (ORID)document.field("bucket", ORID.class);
        OIdentifiable component = (OIdentifiable)document.field(P_COMPONENT, OIdentifiable.class);
        ODocument node = null;
        if (component != null) {
            node = (ODocument)component.getRecord();
        }
        if (node == null) {
            node = document;
        }
        return bucketId + "@" + node.field("name", OType.STRING);
    }

    public boolean exists(ODatabaseDocumentTx db, String name, Bucket bucket) {
        ImmutableMap params = ImmutableMap.of((Object)"name", (Object)Preconditions.checkNotNull((Object)name), (Object)"bucket", (Object)this.recordIdentity(EntityHelper.id((Entity)((Entity)Preconditions.checkNotNull((Object)((Object)bucket))))));
        return !Iterables.isEmpty((Iterable)((Iterable)db.command(EXISTS_QUERY).execute(new Object[]{params})));
    }

    public boolean resolveConflicts() {
        return true;
    }
}

