/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.browse.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeCollisionException;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;

@Named
@Singleton
public class BrowseNodeEntityAdapter
extends IterableEntityAdapter<BrowseNode> {
    private static final String DB_CLASS = new OClassNameBuilder().type("browse_node").build();
    public static final String P_REPOSITORY_NAME = "repository_name";
    public static final String P_PARENT_PATH = "parent_path";
    public static final String P_NAME = "name";
    public static final String P_COMPONENT_ID = "component_id";
    public static final String P_ASSET_ID = "asset_id";
    public static final String P_ASSET_NAME_LOWERCASE = "asset_name_lowercase";
    public static final String AUTHZ_REPOSITORY_NAME = "authz_repository_name";
    private static final String BASE_PATH = "base_path";
    private static final String BASE_BOUNDARY = "base_boundary";
    private static final String SUBTREE_BOUNDARY = "subtree_boundary";
    private static final String I_REPOSITORY_NAME_PARENT_PATH_NAME = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").property("parent_path").property("name").build();
    private static final String I_COMPONENT_ID = new OIndexNameBuilder().type(DB_CLASS).property("component_id").build();
    private static final String I_ASSET_ID = new OIndexNameBuilder().type(DB_CLASS).property("asset_id").build();
    private static final String FIND_BY_PATH = String.format("select expand(rid) from index:%s where key=[:%s,:%s,:%s] limit 1", I_REPOSITORY_NAME_PARENT_PATH_NAME, "repository_name", "parent_path", "name");
    private static final String FIND_CHILDREN = String.format("select from %s where (%s=:%s and %s=:%s)", DB_CLASS, "repository_name", "repository_name", "parent_path", "base_path");
    private static final String FIND_FIRST_SUBTREE = String.format("select from %s where (%s=:%s and %s>:%s and %s<:%s)", DB_CLASS, "repository_name", "repository_name", "parent_path", "base_path", "parent_path", "base_boundary");
    private static final String FIND_NEXT_SUBTREE = String.format("select from %s where (%s=:%s and %s>=:%s and %s<:%s)", DB_CLASS, "repository_name", "repository_name", "parent_path", "subtree_boundary", "parent_path", "base_boundary");
    private static final String FIND_BY_COMPONENT = String.format("select from %s where %s=:%s", DB_CLASS, "component_id", "component_id");
    private static final String FIND_BY_ASSET = String.format("select from %s where %s=:%s limit 1", DB_CLASS, "asset_id", "asset_id");
    private static final String DELETE_BY_REPOSITORY = String.format("delete from %s where %s=:%s limit :limit", DB_CLASS, "repository_name", "repository_name");
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final int timeoutMillis;

    @Inject
    public BrowseNodeEntityAdapter(ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, BrowseNodeConfiguration configuration) {
        super(DB_CLASS);
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.timeoutMillis = configuration.getQueryTimeout().toMillisI();
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PARENT_PATH, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_COMPONENT_ID, OType.LINK, this.componentEntityAdapter.getSchemaType());
        type.createProperty(P_ASSET_ID, OType.LINK, this.assetEntityAdapter.getSchemaType());
        type.createProperty(P_ASSET_NAME_LOWERCASE, OType.STRING);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        this.defineType(type);
        type.createIndex(I_REPOSITORY_NAME_PARENT_PATH_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME, P_PARENT_PATH, P_NAME});
        ODocument ignoreNullValues = db.newInstance().field("ignoreNullValues", (Object)true);
        type.createIndex(I_COMPONENT_ID, OClass.INDEX_TYPE.NOTUNIQUE.name(), null, ignoreNullValues, new String[]{P_COMPONENT_ID});
        type.createIndex(I_ASSET_ID, OClass.INDEX_TYPE.UNIQUE.name(), null, ignoreNullValues, new String[]{P_ASSET_ID});
    }

    protected BrowseNode newEntity() {
        return new BrowseNode();
    }

    protected void readFields(ODocument document, BrowseNode entity) throws Exception {
        ORID assetId;
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        String parentPath = (String)document.field(P_PARENT_PATH, OType.STRING);
        String name = (String)document.field(P_NAME, OType.STRING);
        entity.setRepositoryName(repositoryName);
        entity.setParentPath(parentPath);
        entity.setName(name);
        ORID componentId = (ORID)document.field(P_COMPONENT_ID, ORID.class);
        if (componentId != null) {
            entity.setComponentId((EntityId)new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, componentId));
        }
        if ((assetId = (ORID)document.field(P_ASSET_ID, ORID.class)) != null) {
            entity.setAssetId((EntityId)new AttachedEntityId((EntityAdapter)this.assetEntityAdapter, assetId));
            String assetNameLowercase = (String)document.field(P_ASSET_NAME_LOWERCASE, OType.STRING);
            entity.setAssetNameLowercase(assetNameLowercase);
        }
    }

    protected void writeFields(ODocument document, BrowseNode entity) throws Exception {
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field(P_PARENT_PATH, (Object)entity.getParentPath());
        document.field(P_NAME, (Object)entity.getName());
        if (entity.getComponentId() != null) {
            document.field(P_COMPONENT_ID, (Object)this.componentEntityAdapter.recordIdentity(entity.getComponentId()));
        }
        if (entity.getAssetId() != null) {
            document.field(P_ASSET_ID, (Object)this.assetEntityAdapter.recordIdentity(entity.getAssetId()));
            document.field(P_ASSET_NAME_LOWERCASE, (Object)entity.getAssetNameLowercase());
        }
    }

    public void createComponentNode(ODatabaseDocumentTx db, String repositoryName, List<String> path, Component component) {
        BrowseNode node = BrowseNodeEntityAdapter.newNode(repositoryName, path);
        ODocument document = BrowseNodeEntityAdapter.findNodeRecord(db, node);
        if (document == null) {
            node.setComponentId(EntityHelper.id((Entity)component));
            this.addEntity(db, (Entity)node);
        } else {
            ORID oldComponentId = (ORID)document.field(P_COMPONENT_ID, ORID.class);
            ORID newComponentId = this.componentEntityAdapter.recordIdentity(component);
            if (oldComponentId == null) {
                document.field(P_COMPONENT_ID, (Object)newComponentId);
                document.save();
            } else if (!oldComponentId.equals((Object)newComponentId)) {
                throw new BrowseNodeCollisionException("Node already has a component");
            }
        }
    }

    public void createAssetNode(ODatabaseDocumentTx db, String repositoryName, List<String> path, Asset asset) {
        BrowseNode node = BrowseNodeEntityAdapter.newNode(repositoryName, path);
        ODocument document = BrowseNodeEntityAdapter.findNodeRecord(db, node);
        if (document == null) {
            node.setAssetId(EntityHelper.id((Entity)asset));
            node.setAssetNameLowercase(Strings2.lower((String)asset.name()));
            this.addEntity(db, (Entity)node);
        } else {
            ORID oldAssetId = (ORID)document.field(P_ASSET_ID, ORID.class);
            ORID newAssetId = this.assetEntityAdapter.recordIdentity(asset);
            if (oldAssetId == null) {
                document.field(P_ASSET_ID, (Object)newAssetId);
                document.field(P_ASSET_NAME_LOWERCASE, (Object)Strings2.lower((String)asset.name()));
                document.save();
            } else if (!oldAssetId.equals((Object)newAssetId)) {
                throw new BrowseNodeCollisionException("Node already has an asset");
            }
        }
    }

    private static BrowseNode newNode(String repositoryName, List<String> path) {
        BrowseNode node = new BrowseNode();
        node.setRepositoryName(repositoryName);
        node.setParentPath(BrowseNodeEntityAdapter.joinPath(path.subList(0, path.size() - 1)));
        node.setName(path.get(path.size() - 1));
        return node;
    }

    @Nullable
    private static ODocument findNodeRecord(ODatabaseDocumentTx db, BrowseNode node) {
        return (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_PATH)).execute(new Object[]{ImmutableMap.of((Object)P_REPOSITORY_NAME, (Object)node.getRepositoryName(), (Object)P_PARENT_PATH, (Object)node.getParentPath(), (Object)P_NAME, (Object)node.getName())})), null);
    }

    public void deleteComponentNode(ODatabaseDocumentTx db, EntityId componentId) {
        Iterable documents = (Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_COMPONENT)).execute(new Object[]{ImmutableMap.of((Object)P_COMPONENT_ID, (Object)this.recordIdentity(componentId))});
        documents.forEach(document -> {
            if (document.containsField(P_ASSET_ID)) {
                document.removeField(P_COMPONENT_ID);
                document.save();
            } else {
                document.delete();
            }
        });
    }

    public void deleteAssetNode(ODatabaseDocumentTx db, EntityId assetId) {
        ODocument document = (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_ASSET)).execute(new Object[]{ImmutableMap.of((Object)P_ASSET_ID, (Object)this.recordIdentity(assetId))})), null);
        if (document != null) {
            if (document.containsField(P_COMPONENT_ID)) {
                document.removeField(P_ASSET_ID);
                document.removeField(P_ASSET_NAME_LOWERCASE);
                document.save();
            } else {
                document.delete();
            }
        }
    }

    public int deleteByRepository(ODatabaseDocumentTx db, String repositoryName, int limit) {
        return (Integer)db.command((OCommandRequest)new OCommandSQL(DELETE_BY_REPOSITORY)).execute(new Object[]{ImmutableMap.of((Object)P_REPOSITORY_NAME, (Object)repositoryName, (Object)"limit", (Object)limit)});
    }

    public List<BrowseNode> getByPath(ODatabaseDocumentTx db, String repositoryName, List<String> path, int maxNodes, String assetFilter, Map<String, Object> filterParameters) {
        UnaryOperator<OCommandSQL> timeoutFunction = this.configureTimeoutFunction(assetFilter);
        ArrayList<BrowseNode> listing = new ArrayList<BrowseNode>();
        HashMap<String, Object> parameters = new HashMap<String, Object>(filterParameters);
        parameters.put(P_REPOSITORY_NAME, repositoryName);
        OCommandSQL sql = BrowseNodeEntityAdapter.buildQuery(FIND_CHILDREN, true, assetFilter, maxNodes);
        String basePath = BrowseNodeEntityAdapter.joinPath(path);
        parameters.put(BASE_PATH, basePath);
        HashMap children = new HashMap();
        this.transform((Iterable)db.command((OCommandRequest)sql).execute(new Object[]{parameters})).forEach(child -> children.put(child.getName(), child));
        sql = BrowseNodeEntityAdapter.buildQuery(FIND_FIRST_SUBTREE, false, assetFilter, 1);
        String baseBoundary = String.valueOf(basePath.substring(0, basePath.length() - 1)) + '0';
        parameters.put(BASE_BOUNDARY, baseBoundary);
        List subtree = (List)db.command((OCommandRequest)timeoutFunction.apply(sql)).execute(new Object[]{parameters});
        sql = BrowseNodeEntityAdapter.buildQuery(FIND_NEXT_SUBTREE, false, assetFilter, 1);
        while (!subtree.isEmpty() && listing.size() < maxNodes) {
            String childName = BrowseNodeEntityAdapter.childName(basePath, (String)((ODocument)subtree.get(0)).field(P_PARENT_PATH));
            BrowseNode child2 = (BrowseNode)((Object)children.remove(childName));
            if (child2 == null) {
                child2 = new BrowseNode();
                child2.setRepositoryName(repositoryName);
                child2.setParentPath(basePath);
                child2.setName(childName);
            }
            listing.add(child2);
            String subtreeBoundary = String.valueOf(basePath) + childName + '0';
            parameters.put(SUBTREE_BOUNDARY, subtreeBoundary);
            subtree = (List)db.command((OCommandRequest)timeoutFunction.apply(sql)).execute(new Object[]{parameters});
        }
        for (BrowseNode child3 : children.values()) {
            if (child3.getAssetId() == null) continue;
            child3.setLeaf(true);
            listing.add(child3);
        }
        return listing;
    }

    private UnaryOperator<OCommandSQL> configureTimeoutFunction(String assetFilter) {
        if (this.timeoutMillis > 0 && !assetFilter.isEmpty()) {
            long deadlineMillis = System.currentTimeMillis() + (long)this.timeoutMillis;
            return sql -> {
                long remainingMillis = Math.max(1L, deadlineMillis - System.currentTimeMillis());
                return new OCommandSQL(String.valueOf(sql.getText()) + " timeout " + remainingMillis + " return");
            };
        }
        return UnaryOperator.identity();
    }

    private static String joinPath(List<String> path) {
        StringBuilder buf = new StringBuilder("/");
        path.forEach(s -> {
            StringBuilder stringBuilder2 = buf.append((String)s).append('/');
        });
        return buf.toString();
    }

    private static String childName(String basePath, String path) {
        return path.substring(basePath.length(), path.indexOf(47, basePath.length()));
    }

    private static OCommandSQL buildQuery(String select, boolean includeNonAssetNodes, String assetFilter, int limit) {
        StringBuilder buf = new StringBuilder(select);
        if (!assetFilter.isEmpty()) {
            buf.append(" and (").append(P_ASSET_ID);
            if (includeNonAssetNodes) {
                buf.append(" is null or ");
            } else {
                buf.append(" is not null and ");
            }
            buf.append(assetFilter).append(')');
        }
        buf.append(" limit ").append(limit);
        return new OCommandSQL(buf.toString());
    }

    public boolean resolveConflicts() {
        return true;
    }
}

