/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientOperations;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeComparator;
import org.sonatype.nexus.repository.storage.BrowseNodeEntityAdapter;
import org.sonatype.nexus.repository.storage.BrowseNodeFilter;
import org.sonatype.nexus.repository.storage.BrowseNodeStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.CselAssetSql;
import org.sonatype.nexus.selector.CselAssetSqlBuilder;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Named
public class BrowseNodeStoreImpl
extends StateGuardLifecycleSupport
implements BrowseNodeStore {
    private static final String ASSET_FIELD_PREFIX = "asset_id.";
    private final Provider<DatabaseInstance> databaseInstance;
    private final BrowseNodeEntityAdapter entityAdapter;
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final CselAssetSqlBuilder cselAssetSqlBuilder;
    private final Map<String, BrowseNodeFilter> browseNodeFilters;
    private final Map<String, BrowseNodeComparator> browseNodeComparators;
    private final BrowseNodeComparator defaultBrowseNodeComparator;
    private final int deletePageSize;

    @Inject
    public BrowseNodeStoreImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstance, BrowseNodeEntityAdapter entityAdapter, SecurityHelper securityHelper, SelectorManager selectorManager, CselAssetSqlBuilder cselAssetSqlBuilder, BrowseNodeConfiguration configuration, Map<String, BrowseNodeFilter> browseNodeFilters, Map<String, BrowseNodeComparator> browseNodeComparators) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (BrowseNodeEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.cselAssetSqlBuilder = (CselAssetSqlBuilder)Preconditions.checkNotNull((Object)cselAssetSqlBuilder);
        this.browseNodeFilters = (Map)Preconditions.checkNotNull(browseNodeFilters);
        this.browseNodeComparators = (Map)Preconditions.checkNotNull(browseNodeComparators);
        this.deletePageSize = configuration.getDeletePageSize();
        this.defaultBrowseNodeComparator = (BrowseNodeComparator)Preconditions.checkNotNull((Object)browseNodeComparators.get("default"));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void createComponentNode(String repositoryName, List<String> path, Component component) {
        ((OrientOperations)OrientTransactional.inTxRetry(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordDuplicatedException.class})).run(db -> this.entityAdapter.createComponentNode(db, repositoryName, path, component));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void createAssetNode(String repositoryName, List<String> path, Asset asset) {
        ((OrientOperations)OrientTransactional.inTxRetry(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordDuplicatedException.class})).run(db -> this.entityAdapter.createAssetNode(db, repositoryName, path, asset));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteComponentNode(EntityId componentId) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteComponentNode(db, componentId));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteAssetNode(EntityId assetId) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteAssetNode(db, assetId));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteByRepository(String repositoryName) {
        int deletedCount;
        this.log.debug("Deleting all browse nodes for repository {}", (Object)repositoryName);
        ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        do {
            deletedCount = (Integer)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.deleteByRepository(db, repositoryName, this.deletePageSize));
            progressLogger.info("Deleted {} browse nodes for repository {} in {}", new Object[]{deletedCount, repositoryName, progressLogger.getElapsed()});
        } while (deletedCount == this.deletePageSize);
        progressLogger.flush();
        this.log.debug("All browse nodes deleted for repository {} in {}", (Object)repositoryName, (Object)progressLogger.getElapsed());
    }

    @Override
    @Guarded(by={"STARTED"})
    public Iterable<BrowseNode> getByPath(Repository repository, List<String> path, int maxNodes, @Nullable String keyword) {
        String format;
        List selectors = Collections.emptyList();
        String repositoryName = repository.getName();
        if (!this.hasBrowsePermission(repositoryName, format = repository.getFormat().getValue()) && (selectors = this.selectorManager.browseActive(Arrays.asList(repositoryName), Arrays.asList(format))).isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> filterParameters = new HashMap<String, Object>();
        String assetFilter = this.buildAssetFilter(repository, keyword, selectors, filterParameters);
        BrowseNodeFilter filter = this.browseNodeFilters.getOrDefault(repository.getFormat().getValue(), (node, name) -> true);
        List<BrowseNode> results = repository.getType() instanceof GroupType ? BrowseNodeStoreImpl.members(repository).map(m -> this.getByPath(m.getName(), path, maxNodes, assetFilter, filterParameters)).flatMap(Collection::stream).filter(BrowseNodeStoreImpl.distinctByName()).filter(node -> filter.test(node, repositoryName)).limit(maxNodes).collect(Collectors.toList()) : this.getByPath(repository.getName(), path, maxNodes, assetFilter, filterParameters).stream().filter(node -> filter.test(node, repositoryName)).collect(Collectors.toList());
        results.sort(this.getBrowseNodeComparator(format));
        return results;
    }

    private static Predicate<BrowseNode> distinctByName() {
        HashSet names = new HashSet();
        return node -> names.add(node.getName());
    }

    private static Stream<Repository> members(Repository repository) {
        return repository.facet(GroupFacet.class).leafMembers().stream();
    }

    private List<BrowseNode> getByPath(String repositoryName, List<String> path, int maxNodes, @Nullable String assetFilter, @Nullable Map<String, Object> filterParameters) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByPath(db, repositoryName, path, maxNodes, assetFilter, filterParameters));
    }

    private String buildAssetFilter(Repository repository, @Nullable String keyword, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        StringBuilder filterBuilder = new StringBuilder();
        if (keyword != null) {
            this.appendKeywordFilter(filterBuilder, keyword, filterParameters);
        }
        if (!selectors.isEmpty()) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(" and ");
            }
            this.appendContentAuthFilter(filterBuilder, repository, selectors, filterParameters);
        }
        return filterBuilder.toString();
    }

    private boolean hasBrowsePermission(String repositoryName, String format) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(format, repositoryName, "browse")});
    }

    private void appendKeywordFilter(StringBuilder filterBuilder, String keyword, Map<String, Object> filterParameters) {
        filterBuilder.append("asset_name_lowercase").append(" like :keyword_filter");
        filterParameters.put("keyword_filter", String.valueOf('%') + Strings2.lower((String)keyword) + '%');
    }

    private void appendContentAuthFilter(StringBuilder filterBuilder, Repository repository, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        if (selectors.size() > 1) {
            filterBuilder.append('(');
        }
        int cselCount = 0;
        for (SelectorConfiguration selector : selectors) {
            if (!"csel".equals(selector.getType())) continue;
            if (cselCount > 0) {
                filterBuilder.append(" or ");
            }
            String expression = (String)selector.getAttributes().get("expression");
            CselAssetSql cselAssetSql = this.cselAssetSqlBuilder.buildWhereClause(expression, format, "s" + cselCount++ + "p", ASSET_FIELD_PREFIX);
            filterBuilder.append('(').append(cselAssetSql.getSql()).append(')');
            filterParameters.putAll(cselAssetSql.getSqlParameters());
        }
        if (selectors.size() > cselCount) {
            if (cselCount > 0) {
                filterBuilder.append(" or ");
            }
            filterBuilder.append(String.format("contentAuth(@this.%s, :%s, true) = true", "asset_id", "authz_repository_name"));
            filterParameters.put("authz_repository_name", repositoryName);
        }
        if (selectors.size() > 1) {
            filterBuilder.append(')');
        }
    }

    private Comparator<BrowseNode> getBrowseNodeComparator(String format) {
        return this.browseNodeComparators.getOrDefault(format, this.defaultBrowseNodeComparator);
    }
}

