/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentCreatedEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapterExtension;
import org.sonatype.nexus.repository.storage.ComponentFactory;
import org.sonatype.nexus.repository.storage.ComponentUpdatedEvent;
import org.sonatype.nexus.repository.storage.MetadataNodeEntityAdapter;

@Named
@Singleton
public class ComponentEntityAdapter
extends MetadataNodeEntityAdapter<Component> {
    public static final String DB_CLASS = new OClassNameBuilder().type("component").build();
    public static final String P_GROUP = "group";
    public static final String P_VERSION = "version";
    public static final String P_CI_NAME = "ci_name";
    private static final String I_BUCKET_GROUP_NAME_VERSION = new OIndexNameBuilder().type(DB_CLASS).property("bucket").property("group").property("name").property("version").build();
    private static final String I_BUCKET_NAME_VERSION = new OIndexNameBuilder().type(DB_CLASS).property("bucket").property("name").property("version").build();
    private static final String I_CI_NAME_CASE_INSENSITIVE = new OIndexNameBuilder().type(DB_CLASS).property("ci_name").caseInsensitive().build();
    public static final String I_GROUP_NAME_VERSION_INSENSITIVE = new OIndexNameBuilder().type(DB_CLASS).property("group").property("name").property("version").caseInsensitive().build();
    private static final String EXISTS_QUERY_STRING = String.format("select from index:%1$s where key = [:%2$s, :%3$s, :%4$s, :%5$s]", I_BUCKET_GROUP_NAME_VERSION, "bucket", "group", "name", "version");
    private static final OSQLSynchQuery<ODocument> EXISTS_QUERY = new OSQLSynchQuery(EXISTS_QUERY_STRING, 1);
    private final ComponentFactory componentFactory;
    private final Set<ComponentEntityAdapterExtension> componentEntityAdapterExtensions;

    @Inject
    public ComponentEntityAdapter(BucketEntityAdapter bucketEntityAdapter, ComponentFactory componentFactory, Set<ComponentEntityAdapterExtension> componentEntityAdapterExtensions) {
        super(DB_CLASS, bucketEntityAdapter);
        this.componentFactory = componentFactory;
        this.componentEntityAdapterExtensions = (Set)Preconditions.checkNotNull(componentEntityAdapterExtensions);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(type);
        type.createProperty(P_GROUP, OType.STRING);
        type.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_VERSION, OType.STRING);
        type.createProperty(P_CI_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        ODocument metadata = db.newInstance().field("ignoreNullValues", (Object)false).field("mergeKeys", (Object)false);
        type.createIndex(I_BUCKET_GROUP_NAME_VERSION, OClass.INDEX_TYPE.UNIQUE.name(), null, metadata, new String[]{"bucket", P_GROUP, "name", P_VERSION});
        type.createIndex(I_BUCKET_NAME_VERSION, OClass.INDEX_TYPE.NOTUNIQUE.name(), null, metadata, new String[]{"bucket", "name", P_VERSION});
        new OIndexBuilder(type, I_GROUP_NAME_VERSION_INSENSITIVE, OClass.INDEX_TYPE.NOTUNIQUE).property(P_GROUP, OType.STRING).property("name", OType.STRING).property(P_VERSION, OType.STRING).caseInsensitive().build(db);
        new OIndexBuilder(type, I_CI_NAME_CASE_INSENSITIVE, OClass.INDEX_TYPE.NOTUNIQUE).property(P_CI_NAME, OType.STRING).caseInsensitive().build(db);
        this.componentEntityAdapterExtensions.forEach(d -> d.defineType(db, type));
    }

    public Iterable<Component> browseByNameCaseInsensitive(ODatabaseDocumentTx db, String name, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix) {
        Preconditions.checkNotNull((Object)name);
        String whereClause = " where (ci_name = :name)";
        StringBuilder query = new StringBuilder("select from " + DB_CLASS + whereClause);
        this.addBucketConstraints(whereClause, buckets, query);
        if (querySuffix != null) {
            query.append(' ').append(querySuffix);
        }
        ImmutableMap parameters = ImmutableMap.of((Object)"name", (Object)name);
        this.log.debug("Finding {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        return this.transform((Iterable)db.command((OCommandRequest)new OCommandSQL(query.toString())).execute(new Object[]{parameters}));
    }

    public boolean exists(ODatabaseDocumentTx db, @Nullable String group, String name, @Nullable String version, Bucket bucket) {
        HashMap params = Maps.newHashMap();
        params.put(P_GROUP, group);
        params.put("name", Preconditions.checkNotNull((Object)name));
        params.put(P_VERSION, version);
        params.put("bucket", this.recordIdentity(EntityHelper.id((Entity)((Entity)Preconditions.checkNotNull((Object)((Object)bucket))))));
        return !Iterables.isEmpty((Iterable)((Iterable)db.command(EXISTS_QUERY).execute(new Object[]{params})));
    }

    protected Component newEntity() {
        return this.componentFactory.createComponent();
    }

    @Override
    protected void readFields(ODocument document, Component entity) {
        super.readFields(document, entity);
        String group = (String)document.field(P_GROUP, OType.STRING);
        String name = (String)document.field("name", OType.STRING);
        String version = (String)document.field(P_VERSION, OType.STRING);
        entity.group(group);
        entity.name(name);
        entity.version(version);
        this.componentEntityAdapterExtensions.forEach(d -> d.readFields(document, entity));
    }

    @Override
    protected void writeFields(ODocument document, Component entity) {
        super.writeFields(document, entity);
        document.field(P_GROUP, (Object)entity.group());
        document.field("name", (Object)entity.name());
        document.field(P_VERSION, (Object)entity.version());
        document.field(P_CI_NAME, (Object)entity.name().toLowerCase(Locale.ENGLISH));
        this.componentEntityAdapterExtensions.forEach(d -> d.writeFields(document, entity));
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String repositoryName = (String)((ODocument)document.field("bucket")).field("repository_name");
        this.componentEntityAdapterExtensions.forEach(d -> d.prefetchFields(document));
        switch (eventKind) {
            case CREATE: {
                return new ComponentCreatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case UPDATE: {
                return new ComponentUpdatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case DELETE: {
                return new ComponentDeletedEvent((EntityMetadata)metadata, repositoryName);
            }
        }
        return null;
    }

    public String eventAffinity(ODocument document) {
        ORID bucketId = (ORID)document.field("bucket", ORID.class);
        return bucketId + "@" + document.field("name", OType.STRING);
    }

    public boolean resolveConflicts() {
        return true;
    }
}

